/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.DocDefaults;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StyleDefinitionsPart
extends JaxbXmlPart<Styles> {
    private static Logger log = Logger.getLogger(StyleDefinitionsPart.class);
    private static Map<String, Style> knownStyles = null;
    private Style defaultCharacterStyle;
    private static final String DEFAULT_CHARACTER_STYLE_DEFAULT = "<w:style w:type=\"character\" w:default=\"1\" w:styleId=\"DefaultParagraphFont\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:name w:val=\"Default Paragraph Font\" /></w:style>";
    private Style defaultParagraphStyle;
    static final String wNamespaceDec = " xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"";
    public static final String rPrDefaultsString = "<w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>";
    public static final String pPrDefaultsString = "<w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>";
    public static final String docDefaultsString = "<w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>";

    public StyleDefinitionsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public StyleDefinitionsPart() throws InvalidFormatException {
        super(new PartName("/word/styles.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
    }

    public Object unmarshalDefaultStyles() throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource("org/docx4j/openpackaging/parts/WordprocessingML/styles.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.unmarshal(is);
    }

    private static void initKnownStyles() {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource("org/docx4j/openpackaging/parts/WordprocessingML/KnownStyles.xml");
            JAXBContext jc = Context.jc;
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Styles styles = (Styles)u.unmarshal(is);
            knownStyles = new HashMap<String, Style>();
            for (Style s : styles.getStyle()) {
                knownStyles.put(s.getStyleId(), s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Style> getKnownStyles() {
        if (knownStyles == null) {
            StyleDefinitionsPart.initKnownStyles();
        }
        return knownStyles;
    }

    protected void createVirtualStylesForDocDefaults() throws Docx4JException {
        RPr documentDefaultRPr;
        PPr documentDefaultPPr;
        Style pDefault = Context.getWmlObjectFactory().createStyle();
        String ROOT_NAME = "DocDefaults";
        pDefault.setStyleId(ROOT_NAME);
        pDefault.setType("paragraph");
        DocDefaults docDefaults = ((Styles)this.jaxbElement).getDocDefaults();
        if (docDefaults == null) {
            try {
                docDefaults = (DocDefaults)XmlUtils.unmarshalString(docDefaultsString);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>", (Exception)((Object)e));
            }
        }
        if (docDefaults.getPPrDefault() == null) {
            try {
                documentDefaultPPr = (PPr)XmlUtils.unmarshalString(pPrDefaultsString);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>", (Exception)((Object)e));
            }
        } else {
            documentDefaultPPr = docDefaults.getPPrDefault().getPPr();
        }
        if (docDefaults.getRPrDefault() == null) {
            try {
                documentDefaultRPr = (RPr)XmlUtils.unmarshalString(rPrDefaultsString);
            }
            catch (JAXBException e) {
                throw new Docx4JException("Problem unmarshalling <w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"22\" /><w:szCs w:val=\"22\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>", (Exception)((Object)e));
            }
        } else {
            documentDefaultRPr = docDefaults.getRPrDefault().getRPr();
        }
        pDefault.setPPr(documentDefaultPPr);
        pDefault.setRPr(documentDefaultRPr);
        Style normal = this.getDefaultParagraphStyle();
        if (normal == null) {
            log.warn((Object)"No default paragraph style!!");
            normal = Context.getWmlObjectFactory().createStyle();
            normal.setType("paragraph");
            normal.setStyleId("Normal");
            Style.Name n = Context.getWmlObjectFactory().createStyleName();
            n.setVal("Normal");
            normal.setName(n);
            ((Styles)this.jaxbElement).getStyle().add(normal);
        }
        Style.BasedOn based = Context.getWmlObjectFactory().createStyleBasedOn();
        based.setVal(ROOT_NAME);
        normal.setBasedOn(based);
        ((Styles)this.jaxbElement).getStyle().add(pDefault);
        log.debug((Object)("Added virtual style, id '" + pDefault.getStyleId() + "', name '" + pDefault.getName() + "'"));
    }

    private Style getStyleById(String id) {
        for (Style s : ((Styles)this.jaxbElement).getStyle()) {
            if (!s.getStyleId().equals(id)) continue;
            return s;
        }
        return null;
    }

    public Style getDefaultCharacterStyle() {
        if (this.defaultCharacterStyle == null) {
            this.defaultCharacterStyle = this.getDefaultStyle("character");
        }
        if (this.defaultCharacterStyle == null) {
            try {
                this.defaultCharacterStyle = (Style)XmlUtils.unmarshalString(DEFAULT_CHARACTER_STYLE_DEFAULT);
                ((Styles)this.jaxbElement).getStyle().add(this.defaultCharacterStyle);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return this.defaultCharacterStyle;
    }

    public Style getDefaultParagraphStyle() {
        if (this.defaultParagraphStyle == null) {
            this.defaultParagraphStyle = this.getDefaultStyle("paragraph");
        }
        if (this.defaultParagraphStyle == null) {
            for (Style s : ((Styles)this.jaxbElement).getStyle()) {
                if (!s.getType().equals("paragraph") || !s.getName().getVal().equals("Default")) continue;
                log.info((Object)("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style"));
                this.defaultParagraphStyle = s;
                break;
            }
        }
        if (this.defaultParagraphStyle == null) {
            for (Style s : ((Styles)this.jaxbElement).getStyle()) {
                if (!s.getType().equals("paragraph") || !s.getStyleId().equals("style0")) continue;
                log.info((Object)("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style"));
                this.defaultParagraphStyle = s;
                break;
            }
        }
        return this.defaultParagraphStyle;
    }

    private Style getDefaultStyle(String type) {
        for (Style s : ((Styles)this.jaxbElement).getStyle()) {
            if (!s.isDefault() || !s.getType().equals(type)) continue;
            log.info((Object)("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style"));
            return s;
        }
        return null;
    }
}

