/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.relationships;

import java.io.File;
import org.apache.log4j.Logger;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.AlteredParts;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlteredPartsTest {
    protected static Logger log = Logger.getLogger(AlteredPartsTest.class);
    private static String resourceDir = System.getProperty("user.dir") + "/src/test/resources/AlteredParts/";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void initJaxbContext() throws Exception {
        Context.getWmlObjectFactory();
    }

    @Test
    public void testSimpleDocx() throws Exception {
        log.warn((Object)"\ntestSimpleDocx\n");
        String inputfilepath = resourceDir + "paragraph-single.docx";
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testExtraParagraph() throws Exception {
        log.warn((Object)"\ntestExtraParagraph\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-two.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHyperlink() throws Exception {
        log.warn((Object)"\ntestHyperlink\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "hyperlink.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImageScaled() throws Exception {
        log.warn((Object)"\ntestImageScaled\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png1.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png1-scaled.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImagesDifferentPng() throws Exception {
        log.warn((Object)"\testImagesDifferentPng\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png1.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png2.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImagesRelId() throws Exception {
        log.warn((Object)"\ntestImagesDifferentPng\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "images-jpg then png2.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png2.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testImagesOrderSwapped() throws Exception {
        log.warn((Object)"\ntestImagesOrderSwapped\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "images-jpg then png2.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "images-png2 then jpg.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaderAdded() throws Exception {
        log.warn((Object)"\ntestHeaderAdded\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaderAddedSection2() throws Exception {
        log.warn((Object)"\ntestHeaderAddedSection2\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-section2.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaderImageAdded() throws Exception {
        log.warn((Object)"\ntestHeaderImageAdded\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple-plus-image.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComment() throws Exception {
        log.warn((Object)"\ntestComment\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "comments-one.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testComment2() throws Exception {
        log.warn((Object)"\ntestComment2\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "comments-two.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "comments-one.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        alterations.debug();
        Assert.assertTrue((alterations.getPartsAdded().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsModified().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((alterations.getPartsDeleted().size() == 0 ? 1 : 0) != 0);
    }
}

