/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.relationships;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.docx4j.convert.out.flatOpcXml.FlatOpcXmlCreator;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.AlteredParts;
import org.docx4j.openpackaging.parts.relationships.Patcher;
import org.docx4j.xmlPackage.Package;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class PatcherTest {
    protected static Logger log = Logger.getLogger(PatcherTest.class);
    private static String resourceDir = System.getProperty("user.dir") + "/src/test/resources/AlteredParts/";
    static boolean save = true;
    static String DIR_OUT = System.getProperty("user.dir") + "/src/test/";

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void initJaxbContext() throws Exception {
        Context.getWmlObjectFactory();
    }

    @Test
    public void testSimpleDocx() throws Exception {
        log.warn((Object)"\ntestSimpleDocx\n");
        String inputfilepath = resourceDir + "paragraph-single.docx";
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testExtraParagraph() throws Exception {
        log.warn((Object)"\ntestExtraParagraph\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-two.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testHyperlink() throws Exception {
        log.warn((Object)"\ntestHyperlink\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "hyperlink.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testImageScaled() throws Exception {
        log.warn((Object)"\ntestImageScaled\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png1.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png1-scaled.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testImagesDifferentPng() throws Exception {
        log.warn((Object)"\testImagesDifferentPng\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png1.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png2.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testImagesRelId() throws Exception {
        log.warn((Object)"\ntestImagesDifferentPng\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "images-jpg then png2.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "image-png2.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testImagesOrderSwapped() throws Exception {
        log.warn((Object)"\ntestImagesOrderSwapped\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "images-jpg then png2.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "images-png2 then jpg.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testHeaderAdded() throws Exception {
        log.warn((Object)"\ntestHeaderAdded\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testHeaderAddedSection2() throws Exception {
        log.warn((Object)"\ntestHeaderAddedSection2\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-section2.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testHeaderImageAdded() throws Exception {
        log.warn((Object)"\ntestHeaderImageAdded\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple-plus-image.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "header-simple.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testComment() throws Exception {
        log.warn((Object)"\ntestComment\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "comments-one.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "paragraph-single.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    @Test
    public void testComment2() throws Exception {
        log.warn((Object)"\ntestComment2\n");
        WordprocessingMLPackage thisPackage = WordprocessingMLPackage.load(new File(resourceDir + "comments-two.docx"));
        WordprocessingMLPackage otherPackage = WordprocessingMLPackage.load(new File(resourceDir + "comments-one.docx"));
        AlteredParts.Alterations alterations = AlteredParts.start(thisPackage, otherPackage);
        Patcher.apply(otherPackage, alterations);
        assert (Arrays.equals(this.marshallFlatOPC(thisPackage).toByteArray(), this.marshallFlatOPC(otherPackage).toByteArray()));
    }

    private ByteArrayOutputStream marshallFlatOPC(WordprocessingMLPackage wmlPkg) throws JAXBException, Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FlatOpcXmlCreator worker = new FlatOpcXmlCreator(wmlPkg);
        Package pkg = worker.get();
        JAXBContext jc = Context.jcXmlPackage;
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
        marshaller.marshal((Object)pkg, (OutputStream)baos);
        return baos;
    }
}

