/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import javax.xml.bind.JAXBContext;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BindingHandler;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.datastorage.OpenDoPEIntegrity;
import org.docx4j.model.datastorage.RemovalHandler;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

public class ContentControlBindingExtensions {
    public static JAXBContext context = Context.jc;

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/word/databinding/invoice.docx";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        String filepathprefix = inputfilepath.substring(0, inputfilepath.lastIndexOf("."));
        System.out.println(filepathprefix);
        StringBuilder timingSummary = new StringBuilder();
        long startTime = System.currentTimeMillis();
        OpenDoPEHandler odh = new OpenDoPEHandler(wordMLPackage);
        odh.preprocess();
        long endTime = System.currentTimeMillis();
        timingSummary.append("OpenDoPEHandler: " + (endTime - startTime));
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
        startTime = System.currentTimeMillis();
        OpenDoPEIntegrity odi = new OpenDoPEIntegrity();
        odi.process(wordMLPackage);
        endTime = System.currentTimeMillis();
        timingSummary.append("\nOpenDoPEIntegrity: " + (endTime - startTime));
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
        SaveToZipFile saver = new SaveToZipFile(wordMLPackage);
        saver.save(filepathprefix + "_preprocessed.docx");
        System.out.println("Saved: " + filepathprefix + "_preprocessed.docx");
        BindingHandler.setHyperlinkStyle("Hyperlink");
        startTime = System.currentTimeMillis();
        BindingHandler.applyBindings(wordMLPackage.getMainDocumentPart());
        endTime = System.currentTimeMillis();
        timingSummary.append("\nBindingHandler.applyBindings: " + (endTime - startTime));
        System.out.println(XmlUtils.marshaltoString(wordMLPackage.getMainDocumentPart().getJaxbElement(), true, true));
        saver.save(filepathprefix + "_bound.docx");
        System.out.println("Saved: " + filepathprefix + "_bound.docx");
        startTime = System.currentTimeMillis();
        RemovalHandler rh = new RemovalHandler();
        rh.removeSDTs(wordMLPackage, RemovalHandler.Quantifier.ALL, new String[0]);
        endTime = System.currentTimeMillis();
        timingSummary.append("\nRemovalHandler: " + (endTime - startTime));
        saver.save(filepathprefix + "_stripped.docx");
        System.out.println("Saved: " + filepathprefix + "_stripped.docx");
        System.out.println(timingSummary);
    }
}

