/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.pdf.PdfConversion;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.samples.AbstractSample;

public class ConvertOutPDF
extends AbstractSample {
    static final String sampleText = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /></w:rPr><w:t xml:space=\"preserve\">${fontname}</w:t></w:r></w:p>";
    static final String sampleTextBold = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /><w:b /></w:rPr><w:t>${fontname} bold;</w:t></w:r></w:p>";
    static final String sampleTextItalic = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /><w:i /></w:rPr><w:t>${fontname} italic; </w:t></w:r></w:p>";
    static final String sampleTextBoldItalic = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:rFonts w:ascii=\"${fontname}\" w:eastAsia=\"${fontname}\" w:hAnsi=\"${fontname}\" w:cs=\"${fontname}\" /><w:b /><w:i /></w:rPr><w:t>${fontname} bold italic</w:t></w:r></w:p>";

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage;
        try {
            ConvertOutPDF.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        System.out.println(inputfilepath);
        String regex = null;
        PhysicalFonts.setRegex(regex);
        if (inputfilepath == null) {
            wordMLPackage = WordprocessingMLPackage.createPackage();
            ConvertOutPDF.createContent(wordMLPackage.getMainDocumentPart());
        } else {
            wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        }
        IdentityPlusMapper fontMapper = new IdentityPlusMapper();
        wordMLPackage.setFontMapper(fontMapper);
        PhysicalFont font = PhysicalFonts.getPhysicalFonts().get("Comic Sans MS");
        fontMapper.getFontMappings().put("Algerian", font);
        Conversion c = new Conversion(wordMLPackage);
        c.setSaveFO(new File(inputfilepath + ".fo"));
        String outputfilepath = inputfilepath == null ? System.getProperty("user.dir") + "/OUT_FontContent.pdf" : inputfilepath + ".pdf";
        FileOutputStream os = new FileOutputStream(outputfilepath);
        ((PdfConversion)c).output(os, new PdfSettings());
        System.out.println("Saved " + outputfilepath);
    }

    public static void createContent(MainDocumentPart wordDocumentPart) {
        try {
            PhysicalFonts.discoverPhysicalFonts();
            Map<String, PhysicalFont> physicalFontMap = PhysicalFonts.getPhysicalFonts();
            Iterator<Map.Entry<String, PhysicalFont>> physicalFontMapIterator = physicalFontMap.entrySet().iterator();
            while (physicalFontMapIterator.hasNext()) {
                Map.Entry<String, PhysicalFont> pairs = physicalFontMapIterator.next();
                if (pairs.getKey() == null) {
                    pairs = physicalFontMapIterator.next();
                }
                String fontName = pairs.getKey();
                PhysicalFont pf = pairs.getValue();
                System.out.println("Added paragraph for " + fontName);
                ConvertOutPDF.addObject(wordDocumentPart, sampleText, fontName);
                PhysicalFont pfVariation = PhysicalFonts.getBoldForm(pf);
                if (pfVariation != null) {
                    ConvertOutPDF.addObject(wordDocumentPart, sampleTextBold, pfVariation.getName());
                }
                if ((pfVariation = PhysicalFonts.getBoldItalicForm(pf)) != null) {
                    ConvertOutPDF.addObject(wordDocumentPart, sampleTextBoldItalic, pfVariation.getName());
                }
                if ((pfVariation = PhysicalFonts.getItalicForm(pf)) == null) continue;
                ConvertOutPDF.addObject(wordDocumentPart, sampleTextItalic, pfVariation.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void addObject(MainDocumentPart wordDocumentPart, String template, String fontName) throws JAXBException {
        HashMap<String, String> substitution = new HashMap<String, String>();
        substitution.put("fontname", fontName);
        Object o = XmlUtils.unmarshallFromTemplate(template, substitution);
        wordDocumentPart.addObject(o);
    }

    static {
        inputfilepath = null;
    }
}

