/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.ObjectFactory;
import org.docx4j.relationships.Relationship;
import org.docx4j.samples.AbstractSample;
import org.docx4j.wml.CTRel;
import org.docx4j.wml.CTSettings;

public class TemplateAttach
extends AbstractSample {
    public static void main(String[] args) throws Exception {
        String templatePath = "file:///C:\\Users\\jsmith\\AppData\\Roaming\\Microsoft\\Templates\\yours.dotm";
        try {
            TemplateAttach.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/OUT_TemplateAttach.docx";
        }
        boolean save = inputfilepath != null;
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Title", "Hello world");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("from docx4j!");
        DocumentSettingsPart dsp = new DocumentSettingsPart();
        CTSettings settings = Context.getWmlObjectFactory().createCTSettings();
        dsp.setJaxbElement(settings);
        wordMLPackage.getMainDocumentPart().addTargetPart(dsp);
        RelationshipsPart rp = RelationshipsPart.createRelationshipsPartForPart(dsp);
        Relationship rel = new ObjectFactory().createRelationship();
        rel.setType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/attachedTemplate");
        rel.setTarget(templatePath);
        rel.setTargetMode("External");
        rp.addRelationship(rel);
        settings.setAttachedTemplate((CTRel)XmlUtils.unmarshalString("<w:attachedTemplate xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" r:id=\"" + rel.getId() + "\"/>", Context.jc, CTRel.class));
        if (save) {
            wordMLPackage.save(new File(inputfilepath));
        } else {
            System.out.println(XmlUtils.marshaltoString(dsp.getJaxbElement(), true, true, dsp.getJAXBContext()));
        }
    }
}

