/*
 * Decompiled with CFR 0.152.
 */
package org.glox4j.samples;

import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.dml.diagram.CTColorTransform;
import org.docx4j.dml.diagram.CTDataModel;
import org.docx4j.dml.diagram.CTDiagramDefinition;
import org.docx4j.dml.diagram.CTElemPropSet;
import org.docx4j.dml.diagram.CTStyleDefinition;
import org.docx4j.dml.diagram.ObjectFactory;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DrawingML.DiagramColorsPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDataPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramLayoutPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramStylePart;
import org.docx4j.samples.AbstractSample;
import org.docx4j.wml.P;
import org.glox4j.openpackaging.packages.GloxPackage;

public class CreateDocx
extends AbstractSample {
    private static Logger log = Logger.getLogger(CreateDocx.class);

    public static void main(String[] args) throws Exception {
        try {
            CreateDocx.getInputFilePath(args);
        }
        catch (IllegalArgumentException e) {
            inputfilepath = System.getProperty("user.dir") + "/sample-docs/glox/extracted/SmartArt-BasicChevronProcess.pptx.glox";
        }
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Title", "Hello world");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("from docx4j!");
        GloxPackage gloxPackage = GloxPackage.load(new File(inputfilepath));
        ObjectFactory factory = new ObjectFactory();
        DiagramLayoutPart layout = new DiagramLayoutPart();
        layout.setJaxbElement(gloxPackage.getDiagramLayoutPart().getJaxbElement());
        ((CTDiagramDefinition)gloxPackage.getDiagramLayoutPart().getJaxbElement()).setUniqueId("mylayout");
        DiagramColorsPart colors = new DiagramColorsPart();
        colors.unmarshal("colorsDef-accent1_2.xml");
        DiagramStylePart style = new DiagramStylePart();
        style.unmarshal("quickStyle-simple1.xml");
        DiagramDataPart data = new DiagramDataPart();
        CTDataModel sampleDataModel = ((CTDiagramDefinition)gloxPackage.getDiagramLayoutPart().getJaxbElement()).getSampData().getDataModel();
        if (sampleDataModel == null || sampleDataModel.getPtLst() == null || sampleDataModel.getPtLst().getPt().size() == 0) {
            System.out.println("No sample data in this glox, so can't create demo docx");
            return;
        }
        CTDataModel clonedDataModel = XmlUtils.deepCopy(sampleDataModel);
        data.setJaxbElement(clonedDataModel);
        CTElemPropSet prSet = factory.createCTElemPropSet();
        prSet.setLoTypeId("mylayout");
        prSet.setQsTypeId(((CTStyleDefinition)style.getJaxbElement()).getUniqueId());
        prSet.setCsTypeId(((CTColorTransform)colors.getJaxbElement()).getUniqueId());
        clonedDataModel.getPtLst().getPt().get(0).setPrSet(prSet);
        String layoutRelId = wordMLPackage.getMainDocumentPart().addTargetPart(layout).getId();
        String dataRelId = wordMLPackage.getMainDocumentPart().addTargetPart(data).getId();
        String colorsRelId = wordMLPackage.getMainDocumentPart().addTargetPart(colors).getId();
        String styleRelId = wordMLPackage.getMainDocumentPart().addTargetPart(style).getId();
        wordMLPackage.getMainDocumentPart().addObject(CreateDocx.createSmartArt(layoutRelId, dataRelId, colorsRelId, styleRelId));
        wordMLPackage.save(new File(System.getProperty("user.dir") + "/glox-p1.docx"));
        System.out.println("Done!");
    }

    public static P createSmartArt(String layoutRelId, String dataRelId, String colorsRelId, String styleRelId) throws Exception {
        String ml = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:rPr><w:noProof/><w:lang w:eastAsia=\"en-AU\"/></w:rPr><w:drawing><wp:inline distT=\"0\" distB=\"0\" distL=\"0\" distR=\"0\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" ><wp:extent cx=\"5486400\" cy=\"3200400\"/><wp:effectExtent l=\"0\" t=\"0\" r=\"0\" b=\"0\"/><wp:docPr id=\"1\" name=\"Diagram 1\"/><wp:cNvGraphicFramePr/><a:graphic xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\"><a:graphicData uri=\"http://schemas.openxmlformats.org/drawingml/2006/diagram\"><dgm:relIds r:dm=\"${dataRelId}\" r:lo=\"${layoutRelId}\" r:qs=\"${styleRelId}\" r:cs=\"${colorsRelId}\" xmlns:dgm=\"http://schemas.openxmlformats.org/drawingml/2006/diagram\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"/></a:graphicData></a:graphic></wp:inline></w:drawing></w:r></w:p>";
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("layoutRelId", layoutRelId);
        mappings.put("dataRelId", dataRelId);
        mappings.put("colorsRelId", colorsRelId);
        mappings.put("styleRelId", styleRelId);
        return (P)XmlUtils.unmarshallFromTemplate(ml, mappings);
    }
}

