/*
 * Decompiled with CFR 0.152.
 */
package org.xlsx4j.samples;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.xlsx4j.sml.CTSst;
import org.xlsx4j.sml.Cell;
import org.xlsx4j.sml.Row;
import org.xlsx4j.sml.STCellType;
import org.xlsx4j.sml.SheetData;
import org.xlsx4j.sml.Worksheet;

public class PartsList {
    private static Logger log = Logger.getLogger(PartsList.class);
    private static List<WorksheetPart> worksheets = new ArrayList<WorksheetPart>();
    private static SharedStrings sharedStrings = null;
    public static HashMap<Part, Part> handled = new HashMap();

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/xlsx/pivot.xlsm";
        OpcPackage xlsxPkg = OpcPackage.load(new File(inputfilepath));
        RelationshipsPart rp = xlsxPkg.getRelationshipsPart();
        StringBuilder sb = new StringBuilder();
        PartsList.printInfo(rp, sb, "");
        PartsList.traverseRelationships(xlsxPkg, rp, sb, "    ");
        System.out.println(sb.toString());
        for (WorksheetPart sheet : worksheets) {
            System.out.println(sheet.getPartName().getName());
            Worksheet ws = (Worksheet)sheet.getJaxbElement();
            SheetData data = ws.getSheetData();
            for (Row r : data.getRow()) {
                System.out.println("row " + r.getR());
                for (Cell c : r.getC()) {
                    if (c.getT().equals((Object)STCellType.S)) {
                        System.out.println("  " + c.getR() + " contains " + ((CTSst)sharedStrings.getJaxbElement()).getSi().get(Integer.parseInt(c.getV())).getT());
                        continue;
                    }
                    System.out.println("  " + c.getR() + " contains " + c.getV());
                }
            }
        }
    }

    public static void printInfo(Part p, StringBuilder sb, String indent) {
        sb.append("\n" + indent + "Part " + p.getPartName() + " [" + p.getClass().getName() + "] ");
        if (p instanceof JaxbXmlPart) {
            Object o = ((JaxbXmlPart)p).getJaxbElement();
            if (o instanceof JAXBElement) {
                sb.append(" containing JaxbElement:" + XmlUtils.JAXBElementDebug((JAXBElement)o));
            } else {
                sb.append(" containing JaxbElement:" + o.getClass().getName());
            }
        }
        if (p instanceof WorksheetPart) {
            worksheets.add((WorksheetPart)p);
        } else if (p instanceof SharedStrings) {
            sharedStrings = (SharedStrings)p;
        }
    }

    public static void traverseRelationships(OpcPackage wordMLPackage, RelationshipsPart rp, StringBuilder sb, String indent) {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.info((Object)("For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget()));
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                sb.append("\n" + indent + "external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            Part part = rp.getPart(r);
            PartsList.printInfo(part, sb, indent);
            if (handled.get(part) != null) {
                sb.append(" [additional reference] ");
                continue;
            }
            handled.put(part, part);
            if (part.getRelationshipsPart() == null) continue;
            PartsList.traverseRelationships(wordMLPackage, part.getRelationshipsPart(), sb, indent + "    ");
        }
    }
}

