/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.editor.InputFileListener;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.BMDesignPage;
import aurora.ide.meta.gef.designer.CreateTablePage;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.ModelMerger;
import aurora.ide.meta.gef.designer.model.ModelUtil;
import aurora.ide.meta.project.AuroraMetaProject;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.EditorPart;
import uncertain.composite.CompositeMap;

public class BMDesigner
extends FormEditor {
    public static final String ID = "aurora.ide.meta.gef.editors.BMDesigner";
    private IFile inputFile;
    private BMModel model;
    private BMDesignPage dpage = new BMDesignPage(this, DesignerMessages.BMDesigner_dpage_id, DesignerMessages.BMDesigner_dpage_name);
    private CreateTablePage epage = new CreateTablePage(this, DesignerMessages.BMDesigner_epage_id, DesignerMessages.BMDesigner_epage_name);

    public BMDesigner() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new InputFileListener((EditorPart)this));
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)this.dpage);
            this.addPage((IFormPage)this.epage);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            CompositeMap map = ModelUtil.toCompositeMap(this.model);
            String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + map.toXML();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            bw.write(xml);
            bw.close();
            this.inputFile.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, monitor);
            out.close();
            this.dpage.setDirty(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        this.dpage.setDirty(false);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (!(input instanceof IFileEditorInput)) {
            this.setPartName(input.getName());
            this.model = new BMModel();
            return;
        }
        IFileEditorInput fi = (IFileEditorInput)input;
        this.inputFile = fi.getFile();
        this.setPartName(this.inputFile.getName());
        IProject proj = this.inputFile.getProject();
        AuroraMetaProject amp = new AuroraMetaProject(proj);
        try {
            amp.getAuroraProject();
        }
        catch (ResourceNotFoundException e) {
            throw new PartInitException("Meta Project:" + proj.getName() + " ,does not refers a Aurora Project.");
        }
        this.open();
    }

    private void open() throws PartInitException {
        ModelMerger merger = new ModelMerger(this.inputFile);
        try {
            merger.initModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.model = merger.getMergedModel();
        if (this.model == null) {
            throw new PartInitException("Can not load model from file :" + this.inputFile.getFullPath().toString());
        }
        this.dpage.setModel(this.model);
        this.epage.setModel(this.model);
        if (merger.isDirty()) {
            this.dpage.setDirty(true);
        }
    }

    public IFile getInputFile() {
        return this.inputFile;
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            return this.getInputFile();
        }
        return super.getAdapter(adapter);
    }
}

