/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.scanners.SQLCodeScanner;
import aurora.ide.helpers.DBManager;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public abstract class CreateTableAction
extends Action {
    private IProject aProj;
    private String tableName;

    public CreateTableAction(IProject aProj) {
        super("Create Table", PrototypeImagesUtils.getImageDescriptor("run.gif"));
        this.aProj = aProj;
    }

    public void run() {
        DBManager dbm = new DBManager(this.aProj);
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = dbm.getConnection();
                stmt = conn.createStatement();
                String[] sql = this.getSQLs();
                this.tableName = this.getTableName(sql[0]);
                this.create(stmt, sql);
                MessageBox mb = new MessageBox(this.getShell(), 65536);
                mb.setText("Success");
                mb.setMessage("Table : " + this.tableName + " created.");
                mb.open();
            }
            catch (Exception e) {
                DialogUtil.showErrorMessageBox((String)e.getMessage());
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void create(Statement stmt, String[] sqls) throws SQLException {
        block4: {
            block5: {
                try {
                    var6_3 = sqls;
                    var5_5 = sqls.length;
                    var4_7 = 0;
                    while (var4_7 < var5_5) {
                        s = var6_3[var4_7];
                        stmt.executeUpdate(s);
                        ++var4_7;
                    }
                    break block4;
                }
                catch (SQLException e) {
                    if (!this.isForce() || e.getMessage().indexOf("ORA-00955") == -1) break block5;
                    this.drop(stmt, this.tableName);
                    var7_11 = sqls;
                    var6_4 = sqls.length;
                    var5_6 = 0;
                    ** while (var5_6 < var6_4)
                }
lbl-1000:
                // 1 sources

                {
                    s = var7_11[var5_6];
                    stmt.executeUpdate(s);
                    ++var5_6;
                    continue;
lbl24:
                    // 1 sources

                    break block4;
                }
            }
            throw e;
        }
        stmt.executeUpdate("create sequence " + this.tableName + "_s");
    }

    private void drop(Statement stmt, String tableName) throws SQLException {
        stmt.executeUpdate("drop table " + tableName);
        stmt.executeUpdate("drop sequence " + tableName + "_s");
    }

    private String getTableName(String sql) {
        Document doc = new Document();
        doc.set(sql);
        SQLCodeScanner scanner = new SQLCodeScanner(new ColorManager());
        scanner.setRange((IDocument)doc, 0, sql.length());
        IToken token = null;
        while ((token = scanner.nextToken()) != Token.EOF) {
            if (!(token.getData() instanceof TextAttribute)) continue;
            TextAttribute text = (TextAttribute)token.getData();
            int tokenOffset = scanner.getTokenOffset();
            int tokenLength = scanner.getTokenLength();
            try {
                if (!text.getForeground().getRGB().equals((Object)IColorConstants.SQL_KEYWORD_COLOR) || !"table".equalsIgnoreCase(doc.get(tokenOffset, tokenLength))) continue;
                int idx = tokenOffset + tokenLength;
                int idx2 = sql.indexOf(40, idx);
                return sql.substring(idx, idx2).trim();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private Shell getShell() {
        Display current = Display.getCurrent();
        Shell shell = (current == null ? Display.getDefault() : current).getActiveShell();
        if (shell == null) {
            shell = new Shell(current);
        }
        return shell;
    }

    public abstract String[] getSQLs();

    public abstract boolean isForce();
}

