/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.model;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.PkRecord;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.designer.model.Relation;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil
implements IDesignerConst {
    private static final String PK = "Pk-Record";
    private static final String RECORDS = String.valueOf(Record.class.getSimpleName()) + "s";
    private static final String RELATIONS = String.valueOf(Relation.class.getSimpleName()) + "s";

    public static CompositeMap toCompositeMap(BMModel model) {
        CommentCompositeMap map = new CommentCompositeMap(BMModel.class.getSimpleName());
        if (model == null) {
            return map;
        }
        map.put((Object)"title", (Object)model.getTitle());
        map.put((Object)"autoextend", (Object)model.getAutoExtends());
        map.put((Object)"defaultdisplay", (Object)model.getDefaultDisplay());
        CompositeMap pkMap = ModelUtil.toCompositeMap(model.getPkRecord());
        pkMap.setName(PK);
        map.addChild(pkMap);
        CommentCompositeMap recordMap = new CommentCompositeMap(RECORDS);
        Record[] recordArray = model.getRecords();
        int n = recordArray.length;
        int n2 = 0;
        while (n2 < n) {
            Record r = recordArray[n2];
            recordMap.addChild(ModelUtil.toCompositeMap(r));
            ++n2;
        }
        map.addChild((CompositeMap)recordMap);
        CommentCompositeMap relationMap = new CommentCompositeMap(RELATIONS);
        Relation[] relationArray = model.getRelations();
        int n3 = relationArray.length;
        n = 0;
        while (n < n3) {
            Relation r = relationArray[n];
            relationMap.addChild(ModelUtil.toCompositeMap(r));
            ++n;
        }
        map.addChild((CompositeMap)relationMap);
        return map;
    }

    private static CompositeMap toCompositeMap(Record r) {
        CommentCompositeMap map = new CommentCompositeMap(Record.class.getSimpleName());
        if (r == null) {
            return null;
        }
        String[] keys = TABLE_COLUMN_PROPERTIES;
        ArrayList<String> keyList = new ArrayList<String>();
        int i = 2;
        while (i < keys.length) {
            keyList.add(keys[i]);
            ++i;
        }
        keyList.add("query_op");
        keyList.add("forInsert");
        keyList.add("forUpdate");
        keyList.add("forQuery");
        keyList.add("forDisplay");
        keyList.add("forLov");
        keyList.add("insertExpression");
        keyList.add("updateExpression");
        keyList.add("foreign");
        for (String k : keyList) {
            map.put((Object)k, r.get(k));
        }
        return map;
    }

    private static CompositeMap toCompositeMap(Relation r) {
        CommentCompositeMap map = new CommentCompositeMap(Relation.class.getSimpleName());
        if (r == null) {
            return null;
        }
        String[] keys = COLUMN_PROPERTIES;
        int i = 2;
        while (i < keys.length) {
            map.put((Object)keys[i], r.get(keys[i]));
            ++i;
        }
        map.put((Object)"ref_prompts", (Object)r.getRefPrompts());
        return map;
    }

    public static BMModel fromCompositeMap(CompositeMap map) {
        CompositeMap relMap;
        CompositeMap recMap;
        BMModel model = new BMModel();
        model.setTitle(map.getString((Object)"title"));
        model.setAutoExtends(map.getString((Object)"autoextend"));
        model.setDefaultDisplay(map.getString((Object)"defaultdisplay"));
        CompositeMap pkMap = map.getChild(PK);
        if (pkMap != null) {
            model.setPkRecord(ModelUtil.getRecord(pkMap));
        }
        if ((recMap = map.getChild(RECORDS)) != null) {
            List list = recMap.getChildsNotNull();
            for (CompositeMap m : list) {
                model.add(ModelUtil.getRecord(m));
            }
        }
        if ((relMap = map.getChild(RELATIONS)) != null) {
            List list = relMap.getChildsNotNull();
            for (CompositeMap m : list) {
                model.add(ModelUtil.getRelation(m));
            }
        }
        return model;
    }

    private static Record getRecord(CompositeMap map) {
        boolean ispk = PK.equals(map.getName());
        Record r = ispk ? new PkRecord() : new Record();
        String[] keys = TABLE_COLUMN_PROPERTIES;
        int i = 2;
        while (i < keys.length) {
            if ("queryfield".equals(keys[i])) {
                r.put(keys[i], map.getBoolean((Object)keys[i]));
            }
            r.put(keys[i], map.get((Object)keys[i]));
            ++i;
        }
        if (!ispk) {
            r.put("query_op", map.get((Object)"query_op"));
            r.put("forInsert", map.getBoolean((Object)"forInsert"));
            r.put("forUpdate", map.getBoolean((Object)"forUpdate"));
            r.put("forQuery", map.getBoolean((Object)"forQuery"));
            r.put("forDisplay", map.getBoolean((Object)"forDisplay"));
            r.put("forLov", map.getBoolean((Object)"forLov"));
            r.put("foreign", map.getBoolean((Object)"foreign"));
            r.put("insertExpression", map.getString((Object)"insertExpression"));
            r.put("updateExpression", map.getString((Object)"updateExpression"));
        }
        return r;
    }

    private static Relation getRelation(CompositeMap map) {
        Relation r = new Relation();
        String[] keys = COLUMN_PROPERTIES;
        int i = 2;
        while (i < keys.length) {
            r.put(keys[i], map.get((Object)keys[i]));
            ++i;
        }
        r.setRefPrompts(map.getString((Object)"ref_prompts"));
        return r;
    }

    public static String getLocalFieldName(BMModel model, String prompt) {
        for (Record r : model.getRecordList()) {
            if (!r.getPrompt().equals(prompt)) continue;
            return r.getName();
        }
        return "";
    }

    public static String getForeignFieldName(IProject project, String prompt, String bmPath) {
        DataSetFieldUtil dsfu = new DataSetFieldUtil(project, "", bmPath);
        ArrayList<CompositeMap> als = dsfu.getLocalFields(dsfu.getBmMap(), false);
        for (CompositeMap m : als) {
            if (!prompt.equals(m.getString((Object)"prompt"))) continue;
            return m.getString((Object)"name");
        }
        return "";
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static String join(List<String> list, String sep) {
        StringBuilder sb = new StringBuilder();
        if (list.size() > 0) {
            sb.append(list.get(0));
        }
        int i = 1;
        while (i < list.size()) {
            sb.append(sep);
            sb.append(list.get(i));
            ++i;
        }
        return sb.toString();
    }

    public static String join(String[] ss, String sep) {
        StringBuilder sb = new StringBuilder();
        if (ss.length > 0) {
            sb.append(ss[0]);
        }
        int i = 1;
        while (i < ss.length) {
            sb.append(sep);
            sb.append(ss[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String computeNamePrefix(IFile inputFile) {
        String fn = inputFile.getFullPath().removeFileExtension().lastSegment();
        if (fn.length() > 3) {
            fn = fn.substring(0, 3);
        }
        return String.valueOf(fn) + "_c";
    }
}

