/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors;

import aurora.ide.meta.extensions.ExtensionComponent;
import aurora.ide.meta.extensions.ExtensionLoader;
import aurora.ide.meta.extensions.PaletteCategory;
import aurora.ide.meta.gef.editors.EditorMode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VScreenEditorExtPaletteFactory {
    private static List<PaletteContainer> createCategories(PaletteRoot root, EditorMode editorMode) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(VScreenEditorExtPaletteFactory.createControlGroup(root));
        List<PaletteCategory> paletteCategories = ExtensionLoader.getPaletteCategories();
        for (PaletteCategory pc : paletteCategories) {
            PaletteContainer createDrawer;
            if (!pc.getFilter().isShowCategory(editorMode) || (createDrawer = VScreenEditorExtPaletteFactory.createDrawer(pc)) == null) continue;
            categories.add(createDrawer);
        }
        return categories;
    }

    private static PaletteContainer createDrawer(PaletteCategory pc) {
        PaletteDrawer drawer = new PaletteDrawer(pc.getLabel(), null);
        ArrayList<PaletteEntry> entries = new ArrayList<PaletteEntry>();
        List<ExtensionComponent> extensionComponents = ExtensionLoader.getExtensionComponents();
        for (ExtensionComponent ec : extensionComponents) {
            PaletteEntry paletteEntry;
            if (!pc.getId().equalsIgnoreCase(ec.getCategoryId()) || (paletteEntry = ec.getCreator().createPaletteEntry()) == null) continue;
            entries.add(paletteEntry);
        }
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        PaletteSeparator sep = new PaletteSeparator("aurora.ide.meta.gef.editors");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public static PaletteRoot createPalette(EditorMode editorMode) {
        PaletteRoot flowPalette = new PaletteRoot();
        flowPalette.addAll(VScreenEditorExtPaletteFactory.createCategories(flowPalette, editorMode));
        return flowPalette;
    }
}

