/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.BoxFigure;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Input;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class InputField
extends Figure
implements IResourceDispose {
    private Input model = null;
    private ResourceDisposer disposer = new ResourceDisposer();

    public void setModel(Input model) {
        this.model = model;
        this.setToolTip((IFigure)new Label(model.getComponentType()));
    }

    public int getLabelWidth() {
        IFigure parent = this.getParent();
        if (parent instanceof BoxFigure) {
            return ((BoxFigure)parent).getLabelWidth();
        }
        return 80;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        String prompt = String.valueOf(this.model.getPrompt()) + " : ";
        Rectangle textRectangle = this.getTextRectangle("prompt", this.getLabelRectangle());
        this.paintStyledText(graphics, prompt, "prompt", textRectangle);
        Rectangle inputRectangle = this.getInputRectangle();
        graphics.setForegroundColor(ColorConstants.EDITOR_BORDER);
        graphics.drawRectangle(inputRectangle.getResized(-1, -1));
        Rectangle r = inputRectangle.getTranslated(1, 1).getResized(-2, -2);
        Color bgColor = ColorConstants.WHITE;
        if (this.model.isRequired()) {
            bgColor = ColorConstants.REQUIRED_BG;
        }
        if (this.model.isReadOnly()) {
            bgColor = ColorConstants.READONLY_BG;
        }
        graphics.setBackgroundColor(bgColor);
        graphics.fillRectangle(r);
        String sd = this.model.getStringPropertyValue("input_simple_data");
        if (sd != null && !"".equals(sd)) {
            if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.model, "input_simple_data")) {
                this.paintStyledText(graphics, sd, "input_simple_data", r);
            } else {
                this.paintSimpleData(graphics, "input_simple_data", r);
            }
        } else {
            this.paintEmptyText(graphics, this.model.getEmptyText(), r);
        }
        Image image = this.getImage();
        if (image != null) {
            Rectangle imageR = inputRectangle.getCopy();
            graphics.drawImage(image, this.getImageLocation().x, this.getImageLocation().y, 16, 16, imageR.getTopRight().x - 18, imageR.getTopRight().y, 16, 16);
        }
    }

    protected void paintStyledText(Graphics g, String text, String property_id, Rectangle r) {
        g.pushState();
        this.disposer.disposeResource(property_id);
        Rectangle copy = r.getCopy();
        g.setForegroundColor(ColorConstants.BLACK);
        Dimension dim = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        if (!"prompt".equals(property_id)) {
            g.setClip(r.getResized(-16, 0));
        }
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.getFont());
        Object obj = this.model.getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)obj, Display.getDefault(), this.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        Point p = new Point(r.x + 2, r.y + (r.height - dim.height) / 2);
        if ("prompt".equals(property_id)) {
            g.drawTextLayout(tl, copy.x, copy.y);
        } else {
            Rectangle textRectangle = this.getTextRectangle(property_id, r);
            g.drawTextLayout(tl, textRectangle.x, textRectangle.y);
        }
        this.disposer.handleResource(property_id, (Resource)tl);
        g.popState();
    }

    protected Rectangle getInputRectangle() {
        Rectangle inputRectangle = new Rectangle();
        inputRectangle.x = this.getBounds().x + this.getLabelWidth() + 1;
        inputRectangle.y = this.getBounds().y + 1;
        int j = this.getBounds().width - this.getLabelWidth() - 1;
        inputRectangle.width = j <= 0 ? 0 : j;
        inputRectangle.height = this.getBounds().height - 1;
        return inputRectangle;
    }

    protected Rectangle getTextRectangle(String property_id, Rectangle rect) {
        String text = this.model.getStringPropertyValue(property_id);
        if ("prompt".equals(property_id)) {
            text = String.valueOf(text) + " : ";
        }
        if ("input_simple_data".equals(property_id)) {
            rect = rect.getCopy().setWidth(rect.width - 18);
        }
        Dimension textExtents = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        Point point = TextStyleUtil.getTextAlignment(rect, text, this.getFont(), this.getAlignmentStyle(property_id));
        return new Rectangle(point, textExtents);
    }

    protected Rectangle getLabelRectangle() {
        Rectangle rect = this.getBounds().getCopy();
        rect.setWidth(this.getLabelWidth());
        return rect;
    }

    private int getAlignmentStyle(String property_id) {
        Object obj = this.model.getPropertyValue(String.valueOf(property_id) + "_text_style");
        if (obj instanceof StyledStringText) {
            return ((StyledStringText)obj).getAlignment();
        }
        return "prompt".equals(property_id) ? 131072 : 16384;
    }

    private void paintEmptyText(Graphics g, String emptyText, Rectangle r) {
        g.pushState();
        g.setForegroundColor(ColorConstants.EDITOR_BORDER);
        g.setClip(r.getResized(-16, 0));
        g.drawString(emptyText, this.calTextLocation(emptyText, r));
        g.popState();
    }

    protected Point calTextLocation(String emptyText, Rectangle r) {
        Dimension dim = FigureUtilities.getTextExtents((String)emptyText, (Font)this.getFont());
        if ("textArea".equals(this.model.getComponentType())) {
            return new Point(r.x + 2, r.y + 2);
        }
        return new Point(r.x + 2, r.y + (r.height - dim.height) / 2);
    }

    protected void paintSimpleData(Graphics g, String propertie_id, Rectangle r) {
        g.pushState();
        g.setForegroundColor(ColorConstants.BLACK);
        g.setClip(r.getResized(-16, 0));
        String text = this.model.getStringPropertyValue(propertie_id);
        g.drawText(text, this.getTextRectangle(propertie_id, r).getTopLeft());
        g.popState();
    }

    private Image getImage() {
        String type = this.model.getComponentType();
        if ("comboBox".equals(type)) {
            return PrototypeImagesUtils.getImage("palette/itembar_01.png");
        }
        if ("datePicker".equals(type) || "dateTimePicker".equals(type)) {
            return PrototypeImagesUtils.getImage("palette/itembar_02.png");
        }
        if ("lov".equals(type)) {
            return PrototypeImagesUtils.getImage("palette/itembar_03.png");
        }
        if ("textField".equals(type)) {
            return PrototypeImagesUtils.getImage("palette/itembar_04.png");
        }
        if ("numberField".equals(type)) {
            return PrototypeImagesUtils.getImage("palette/itembar_05.png");
        }
        return null;
    }

    private Point getImageLocation() {
        Point p = new Point(0, 0);
        return p;
    }

    public void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }

    protected void handleResource(String id, Resource r) {
        this.disposer.handleResource(id, r);
    }

    protected void disposeResource(String prop_id) {
        this.disposer.disposeResource(prop_id);
    }
}

