/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.figures.GridColumnFigure;
import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.GridPart;
import aurora.ide.meta.gef.editors.parts.NavbarPart;
import aurora.ide.meta.gef.editors.parts.ToolbarPart;
import aurora.plugin.source.gen.screen.model.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridBackLayout
extends BackLayout {
    private int col;
    private int row;
    private int maxColHight;
    private int titleHight;
    private Rectangle zero = new Rectangle(0, 0, 0, 0);
    private int lastCol = 0;
    private int lastRow = 0;
    private Rectangle selfRectangle = new Rectangle();
    private Point location = new Point();
    private Container box;
    private int t_col = 0;
    private int t_row = 0;
    private ComponentPart[][] childs;
    private int[] maxColWidths;
    private int[] maxRowHights;
    private int realRow;
    private int maxDepth = 0;
    private Map<ComponentPart, Integer> depthMap = new HashMap<ComponentPart, Integer>();
    private Map<ComponentPart, Rectangle> partMap;
    private GridPart gridPart;
    private ToolbarPart toolbarPart;
    private NavbarPart navbarPart;
    private int navbarHight;

    public Rectangle layout(ComponentPart parent) {
        Rectangle layout;
        ComponentPart ep;
        if (parent instanceof GridPart) {
            this.gridPart = (GridPart)parent;
            this.box = (Container)parent.getComponent();
            this.col = 100;
            this.row = 1;
            Rectangle fBounds = parent.getFigure().getBounds();
            this.selfRectangle = fBounds.isEmpty() ? this.toDraw2d(this.box.getBoundsCopy()) : fBounds;
            this.titleHight = this.hasToolbar() ? 25 : 0;
            this.location.x = 0;
            this.location.y = this.titleHight;
            this.location.translate(this.selfRectangle.getTopLeft());
            this.t_col = 0;
            this.t_row = 0;
            this.maxColWidths = new int[this.col];
            int i = 0;
            while (i < this.col) {
                this.maxColWidths[i] = 0;
                ++i;
            }
            this.partMap = new HashMap<ComponentPart, Rectangle>();
            this.navbarPart = this.getNavbarPart();
            this.toolbarPart = this.getToolbarPart();
            this.navbarHight = this.navbarPart == null ? 0 : 25;
        }
        List children = this.getColumns(parent);
        this.realRow = children.size() / this.col + (children.size() % this.col == 0 ? 0 : 1);
        Rectangle calculateRectangle = this.calculateRectangle(parent);
        if (this.realRow == 0) {
            this.layoutToolbar(calculateRectangle);
            this.layoutNavbar(calculateRectangle);
            return calculateRectangle;
        }
        this.childs = new ComponentPart[this.realRow][this.col];
        this.maxRowHights = new int[this.realRow];
        int i = 0;
        while (i < this.realRow) {
            this.maxRowHights[i] = 0;
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            ep = (ComponentPart)children.get(i);
            if (this.t_col == this.col) {
                ++this.t_row;
                this.t_col = 0;
            }
            this.childs[this.t_row][this.t_col] = ep;
            layout = GraphLayoutManager.layout(ep);
            this.partMap.put(ep, layout);
            ++this.t_col;
            ++i;
        }
        this.calculateMaxWidthHight();
        this.calculateChildLocation();
        i = 0;
        while (i < children.size()) {
            ep = (ComponentPart)children.get(i);
            layout = this.partMap.get(ep);
            this.applyToFigure(ep, layout);
            ++i;
        }
        this.calculateChildDepth(parent, 1);
        this.applyToAllChildCH(parent);
        calculateRectangle = this.calculateRectangle(parent);
        this.layoutToolbar(calculateRectangle);
        this.layoutNavbar(calculateRectangle);
        return calculateRectangle;
    }

    private void layoutToolbar(Rectangle calculateRectangle) {
        Point location = new Point();
        location.translate(this.selfRectangle.getTopLeft());
        if (this.toolbarPart != null) {
            Rectangle layout = GraphLayoutManager.layout(this.toolbarPart);
            Rectangle setLocation = layout.getCopy().setLocation(location);
            setLocation.setWidth(calculateRectangle.width);
            this.applyToFigure(this.toolbarPart, setLocation);
        }
    }

    private void layoutNavbar(Rectangle calculateRectangle) {
        Point bottomLeft = this.selfRectangle.getBottomLeft();
        Point setY = bottomLeft.getCopy().setY(bottomLeft.y - 25);
        if (this.navbarPart != null) {
            Rectangle layout = GraphLayoutManager.layout(this.navbarPart);
            Rectangle setLocation = layout.getCopy().setLocation(setY);
            setLocation.setWidth(calculateRectangle.width);
            this.applyToFigure(this.navbarPart, setLocation);
        }
    }

    private ToolbarPart getToolbarPart() {
        List children = this.gridPart.getChildren();
        for (Object object : children) {
            if (!(object instanceof ToolbarPart)) continue;
            return (ToolbarPart)object;
        }
        return null;
    }

    private NavbarPart getNavbarPart() {
        List children = this.gridPart.getChildren();
        for (Object object : children) {
            if (!(object instanceof NavbarPart)) continue;
            return (NavbarPart)object;
        }
        return null;
    }

    private List getColumns(ComponentPart parent) {
        ArrayList<ComponentPart> columns = new ArrayList<ComponentPart>();
        List children = parent.getChildren();
        for (Object object : children) {
            if (object instanceof NavbarPart || object instanceof ToolbarPart) continue;
            columns.add((ComponentPart)object);
        }
        return columns;
    }

    private void applyToAllChildCH(ComponentPart parent) {
        List children = this.getColumns(parent);
        int columnHight = 25;
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            if (this.getColumns(cp).size() > 0) {
                ((GridColumnFigure)cp.getFigure()).setColumnHight(columnHight);
            } else {
                Integer depth = this.depthMap.get(cp);
                int l = this.maxDepth - depth + 1;
                ((GridColumnFigure)cp.getFigure()).setColumnHight(columnHight * l);
            }
            this.applyToAllChildCH(cp);
            ++i;
        }
    }

    private boolean hasToolbar() {
        return this.getToolbarPart() != null;
    }

    private boolean hasNavbar() {
        return this.getNavbarPart() != null;
    }

    private void calculateChildDepth(ComponentPart parent, int depth) {
        List children = this.getColumns(parent);
        int i = 0;
        while (i < children.size()) {
            this.maxDepth = Math.max(this.maxDepth, depth);
            this.depthMap.put((ComponentPart)children.get(i), depth);
            int t = depth;
            this.calculateChildDepth((ComponentPart)children.get(i), ++t);
            ++i;
        }
    }

    private void calculateMaxWidthHight() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) break;
                Rectangle rr = this.partMap.get(rp);
                this.maxRowHights[i] = Math.max(this.maxRowHights[i], rr.height);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.col) {
            int k = 0;
            while (k < this.realRow) {
                ComponentPart cp = this.childs[k][j];
                if (cp == null) break;
                Rectangle cr = this.partMap.get(cp);
                this.maxColWidths[j] = Math.max(this.maxColWidths[j], cr.width);
                ++k;
            }
            ++j;
        }
    }

    private void calculateChildLocation() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) {
                    return;
                }
                Rectangle rr = this.partMap.get(rp);
                rr.setLocation(this.location);
                this.location.x += this.maxColWidths[j];
                ++j;
            }
            this.location.x = 0 + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxRowHights[i] + 0;
            ++i;
        }
    }

    private Rectangle calculateRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = this.getColumns(parent);
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (selfRectangle.width > this.selfRectangle.width) {
            return this.selfRectangle.getCopy().setWidth(selfRectangle.width + 50);
        }
        selfRectangle = this.toDraw2d(parent.getComponent().getBoundsCopy());
        return this.selfRectangle.setSize(selfRectangle.getSize());
    }
}

