/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.GridColumnPart;
import aurora.plugin.source.gen.screen.model.GridColumn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridColumnBackLayout
extends BackLayout {
    private int col;
    private int row;
    private int maxColHight;
    private int titleHight;
    private Rectangle zero = new Rectangle(0, 0, 0, 0);
    private int lastCol = 0;
    private int lastRow = 0;
    private Rectangle selfRectangle = new Rectangle();
    private Point location = new Point();
    private GridColumn box;
    private int t_col = 0;
    private int t_row = 0;
    private ComponentPart[][] childs;
    private int[] maxColWidths;
    private int[] maxRowHights;
    private int realRow;
    private Map<ComponentPart, Rectangle> partMap;
    private ComponentPart editPart;

    public Rectangle layout(ComponentPart parent) {
        Rectangle layout;
        ComponentPart ep;
        if (parent instanceof GridColumnPart) {
            this.editPart = parent;
            this.box = (GridColumn)parent.getComponent();
            this.col = 100;
            this.row = 1;
            Rectangle fBounds = parent.getFigure().getBounds();
            this.selfRectangle = fBounds.isEmpty() ? this.toDraw2d(this.box.getBoundsCopy()) : fBounds;
            this.titleHight = 25;
            this.location.x = 0;
            this.location.y = this.titleHight + 0 - 1;
            this.location.translate(this.selfRectangle.getTopLeft());
            this.t_col = 0;
            this.t_row = 0;
            this.maxColWidths = new int[this.col];
            int i = 0;
            while (i < this.col) {
                this.maxColWidths[i] = 0;
                ++i;
            }
            this.partMap = new HashMap<ComponentPart, Rectangle>();
        }
        List children = parent.getChildren();
        this.realRow = children.size() / this.col + (children.size() % this.col == 0 ? 0 : 1);
        Rectangle calculateRectangle = this.calculateRectangle(parent);
        if (this.realRow == 0) {
            return calculateRectangle;
        }
        this.childs = new ComponentPart[this.realRow][this.col];
        this.maxRowHights = new int[this.realRow];
        int i = 0;
        while (i < this.realRow) {
            this.maxRowHights[i] = 0;
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            ep = (ComponentPart)children.get(i);
            if (this.t_col == this.col) {
                ++this.t_row;
                this.t_col = 0;
            }
            this.childs[this.t_row][this.t_col] = ep;
            layout = GraphLayoutManager.layout(ep);
            this.partMap.put(ep, layout);
            ++this.t_col;
            ++i;
        }
        this.calculateMaxWidthHight();
        this.calculateChildLocation();
        i = 0;
        while (i < children.size()) {
            ep = (ComponentPart)children.get(i);
            layout = this.partMap.get(ep);
            this.applyToFigure(ep, layout);
            ++i;
        }
        calculateRectangle = this.calculateRectangle(parent);
        return calculateRectangle;
    }

    private void calculateMaxWidthHight() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) break;
                Rectangle rr = this.partMap.get(rp);
                this.maxRowHights[i] = Math.max(this.maxRowHights[i], rr.height);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.col) {
            int k = 0;
            while (k < this.realRow) {
                ComponentPart cp = this.childs[k][j];
                if (cp == null) break;
                Rectangle cr = this.partMap.get(cp);
                this.maxColWidths[j] = Math.max(this.maxColWidths[j], cr.width);
                ++k;
            }
            ++j;
        }
    }

    private void calculateChildLocation() {
        int i = 0;
        while (i < this.realRow) {
            int j = 0;
            while (j < this.col) {
                ComponentPart rp = this.childs[i][j];
                if (rp == null) {
                    return;
                }
                Rectangle rr = this.partMap.get(rp);
                rr.setLocation(this.location);
                rr.setHeight(this.selfRectangle.height - 25);
                this.location.x += this.maxColWidths[j] + 0 - 1;
                ++j;
            }
            this.location.x = 0 + this.selfRectangle.getTopLeft().x;
            this.location.y = this.location.y + this.maxRowHights[i] + 0;
            ++i;
        }
    }

    private Rectangle calculateRectangle(ComponentPart parent) {
        Rectangle selfRectangle = this.zero.getCopy().setLocation(parent.getFigure().getBounds().getLocation());
        List children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            ComponentPart cp = (ComponentPart)children.get(i);
            selfRectangle.union(cp.getFigure().getBounds().getCopy());
            ++i;
        }
        if (!selfRectangle.isEmpty()) {
            return selfRectangle;
        }
        selfRectangle = this.toDraw2d(parent.getComponent().getBoundsCopy());
        return selfRectangle;
    }
}

