/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.policies;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.models.commands.ResizeCmpCmd;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Font;

public class ResizeComponentEditPolicy
extends ResizableEditPolicy
implements PositionConstants {
    private int resizeDirections = 29;
    private Label label = null;

    protected List createSelectionHandles() {
        if (this.resizeDirections == 0) {
            return super.createSelectionHandles();
        }
        ArrayList list = new ArrayList();
        this.createMoveHandle(list);
        if ((this.resizeDirections & 1) == 1) {
            this.createResizeHandle(list, 1);
        }
        if ((this.resizeDirections & 0x10) == 16) {
            this.createResizeHandle(list, 16);
        }
        if ((this.resizeDirections & 4) == 4) {
            this.createResizeHandle(list, 4);
        }
        if ((this.resizeDirections & 8) == 8) {
            this.createResizeHandle(list, 8);
        }
        this.createResizeHandle(list, 20);
        this.createResizeHandle(list, 12);
        this.createResizeHandle(list, 9);
        this.createResizeHandle(list, 17);
        return list;
    }

    public void eraseSourceFeedback(Request request) {
        if ("resize".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
            this.removeFeedback((IFigure)this.label);
            this.label = null;
        } else {
            super.eraseSourceFeedback(request);
        }
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(request);
        if ("resize".equals(request.getType())) {
            Rectangle rect = this.getDragSourceFeedbackFigure().getBounds().getCopy();
            Label label = this.createResizeFeedBack();
            label.setForegroundColor(ColorConstants.TITLETEXT);
            label.setTextAlignment(1);
            String str = String.format("%d x %d", rect.width, rect.height);
            label.setText(str);
            Point md = request.getMoveDelta();
            label.setLocation(md.y != 0 ? rect.getTopRight() : rect.getBottomRight());
            label.setSize(FigureUtilities.getTextExtents((String)str, (Font)label.getFont()));
        }
    }

    protected Label createResizeFeedBack() {
        if (this.label == null) {
            this.label = new Label();
            this.addFeedback((IFigure)this.label);
        }
        return this.label;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ResizeCmpCmd cmd = new ResizeCmpCmd();
        cmd.setHostModel((AuroraComponent)this.getHost().getModel());
        cmd.setSizeDelt(request.getSizeDelta());
        return cmd;
    }

    protected void showSelection() {
        if (!MetaPlugin.isDemonstrate) {
            this.addSelectionHandles();
        }
    }
}

