/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LogUtil;
import aurora.ide.meta.exception.GeneratorException;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.exception.TemplateNotBindedException;
import aurora.ide.meta.gef.FileFinder;
import aurora.ide.meta.gef.editors.source.gen.core.GeneratorManager;
import aurora.ide.meta.gef.editors.source.gen.core.IDEModelMapParser;
import aurora.ide.meta.gef.i18n.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.MessageFormater;
import aurora.plugin.source.gen.BuilderSession;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;

public class ProjectGenerator {
    private IProject project;
    private boolean isOverlap;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private int fNumberOfScannedFiles;
    private Shell shell;
    private IProject auroraProject;
    private IFolder screenFolder;
    private IContainer auroraWebFolder;
    private String errorMessage;
    private GeneratorManager gm;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ProjectGenerator(IProject project, boolean isOverlap, Shell shell) {
        this.project = project;
        this.isOverlap = isOverlap;
        this.shell = shell;
        this.gm = GeneratorManager.createNewInstance(this.getAuroraProject());
    }

    public boolean isOverlap() {
        return this.isOverlap;
    }

    public void setOverlap(boolean isOverlap) {
        this.isOverlap = isOverlap;
    }

    public void go(final IProgressMonitor monitor) throws InvocationTargetException {
        block14: {
            boolean validate = this.validate();
            if (!validate) {
                throw new InvocationTargetException(new GeneratorException());
            }
            FileFinder fileFinder = new FileFinder();
            try {
                this.project.accept((IResourceVisitor)fileFinder);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            List<IResource> files = fileFinder.getResult();
            this.fNumberOfFilesToScan = files.size();
            Job monitorUpdateJob = new Job("source generator"){
                private int fLastNumberOfScannedFiles;
                {
                    super($anonymous0);
                    this.fLastNumberOfScannedFiles = 0;
                }

                public IStatus run(IProgressMonitor inner) {
                    while (!inner.isCanceled()) {
                        IFile file = ProjectGenerator.this.fCurrentFile;
                        if (file != null) {
                            this.updateMonitor(monitor, file);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }

                private void updateMonitor(IProgressMonitor monitor2, IFile file) {
                    String fileName = file.getName();
                    Object[] args = new Object[]{fileName, new Integer(ProjectGenerator.this.fNumberOfScannedFiles), new Integer(ProjectGenerator.this.fNumberOfFilesToScan)};
                    monitor2.subTask(MessageFormater.format((String)"Scanning file {1} of {2}: {0}", (Object[])args));
                    int steps = ProjectGenerator.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                    monitor2.worked(steps);
                    this.fLastNumberOfScannedFiles += steps;
                }
            };
            monitor.beginTask(Messages.ProjectGenerator_Gen_source, files.size());
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                if (files == null) break block14;
                int i = 0;
                while (i < files.size()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.fCurrentFile = (IFile)files.get(i);
                    ++this.fNumberOfScannedFiles;
                    try {
                        this.processFile(this.fCurrentFile, monitor);
                    }
                    catch (IOException e) {
                        break;
                    }
                    catch (TemplateException e) {
                        LogUtil.getInstance().logError("\u6478\u7248\u683c\u5f0f\u5f02\u5e38\uff0c\u4ee3\u7801\u751f\u6210\u7ec8\u6b62\u3002", (Throwable)e);
                        this.errorMessage = "\u6478\u7248\u683c\u5f0f\u5f02\u5e38\uff0c\u4ee3\u7801\u751f\u6210\u7ec8\u6b62\u3002\u67e5\u770blog\u83b7\u5f97\u8be6\u7ec6\u4fe1\u606f\u3002";
                        throw new InvocationTargetException(new GeneratorException());
                    }
                    catch (TemplateNotBindedException e) {
                    }
                    catch (SAXException e) {
                        LogUtil.getInstance().logError("\u751f\u6210\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5ffd\u5f8b\u6b64\u6587\u4ef6 : " + this.fCurrentFile.getName(), (Throwable)e);
                    }
                    ++i;
                }
                this.genMasterDetailSVC();
            }
            finally {
                monitorUpdateJob.cancel();
                monitor.done();
            }
        }
    }

    private void genMasterDetailSVC() throws InvocationTargetException {
        IFile newFile = this.auroraWebFolder.getFile((IPath)new Path("master_detail_auto_save.svc"));
        if (newFile.exists()) {
            return;
        }
        InputStream is = ProjectGenerator.class.getResourceAsStream("master_detail_auto_save.svc");
        CreateFileOperation cfo = new CreateFileOperation(newFile, null, is, "create file."){

            protected void setResourceDescriptions(ResourceDescription[] descriptions) {
                super.setResourceDescriptions(descriptions);
            }

            public IStatus computeExecutionStatus(IProgressMonitor monitor) {
                IStatus status = super.computeExecutionStatus(monitor);
                if (status.isOK()) {
                    status = this.computeCreateStatus(false);
                }
                return status;
            }
        };
        try {
            cfo.execute(null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.shell));
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e);
        }
    }

    public boolean validate() {
        this.auroraProject = this.getAuroraProject();
        this.screenFolder = this.getScreenFolder();
        this.auroraWebFolder = this.getAuroraWebFolder();
        if (this.auroraProject == null) {
            this.errorMessage = Messages.ProjectGenerator_Project_error;
            return false;
        }
        if (this.auroraWebFolder == null) {
            this.errorMessage = Messages.ProjectGenerator_web_error;
            return false;
        }
        if (this.screenFolder == null) {
            this.errorMessage = Messages.ProjectGenerator__folder_erroe;
            return false;
        }
        return true;
    }

    private void genNewFile(IFile newFile, String content) throws InvocationTargetException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (is == null) {
            return;
        }
        if (newFile.exists() && this.isOverlap) {
            try {
                newFile.setContents((InputStream)is, true, false, null);
                return;
            }
            catch (CoreException e1) {
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        CreateFileOperation cfo = new CreateFileOperation(newFile, null, is, "create file."){

            protected void setResourceDescriptions(ResourceDescription[] descriptions) {
                super.setResourceDescriptions(descriptions);
            }

            public IStatus computeExecutionStatus(IProgressMonitor monitor) {
                IStatus status = super.computeExecutionStatus(monitor);
                if (status.isOK()) {
                    status = this.computeCreateStatus(false);
                }
                return status;
            }
        };
        try {
            cfo.execute(null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.shell));
        }
        catch (ExecutionException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void processFile(IFile fCurrentFile, IProgressMonitor monitor) throws InvocationTargetException, IOException, TemplateException, TemplateNotBindedException, SAXException {
        IFile newFile;
        if (fCurrentFile.getName().contains("grid_grid")) {
            System.out.println();
        }
        if ((newFile = this.getNewFile(fCurrentFile)).exists() && !this.isOverlap) {
            return;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((IFile)fCurrentFile);
        BuilderSession session = this.gm.createBuilderSession();
        String fileName = this.getFileName();
        session.addConfig("file_name", (Object)fileName);
        String genFile = this.gm.buildScreen(loadFile, session).toXML();
        this.genNewFile(newFile, genFile);
        this.genRelation(this.gm, loadFile, 0);
    }

    private String getFileName() {
        return this.getFileName(this.fCurrentFile);
    }

    private String getFileName(IFile file) {
        IPath filePath = file.getProjectRelativePath();
        String fileName = filePath.removeFileExtension().lastSegment();
        return fileName;
    }

    private void genRelation(GeneratorManager sgm, CompositeMap loadFile, int i) {
        IDEModelMapParser mmp = new IDEModelMapParser(loadFile, this.getAuroraProject());
        List renderers = mmp.getComponents("renderer");
        for (CompositeMap renderer : renderers) {
            String openpath;
            String type = renderer.getString((Object)"renderer_type", "");
            if (!"PAGE_REDIRECT".equals(type) || "".equals(openpath = renderer.getString((Object)"openpath", "")) || !openpath.toLowerCase().endsWith("uip")) continue;
            CompositeMap inner_paramerter = renderer.getChildByAttrib((Object)"propertye_id", (Object)"renderer_parameters").getChildByAttrib((Object)"component_type", (Object)"inner_paramerter");
            String value = inner_paramerter.getString((Object)"parameter_value", "");
            String name = inner_paramerter.getString((Object)"parameter_name", "");
            this.genRelationFile(sgm, i, openpath, name, value);
        }
    }

    private void genRelationFile(GeneratorManager sgm, int i, String openPath, String para_name, String para_value) {
        if (i > 10) {
            return;
        }
        ++i;
        if (openPath == null || "".equals(openPath)) {
            return;
        }
        Path p = new Path(openPath);
        if ("uip".equalsIgnoreCase(p.getFileExtension())) {
            IFile fCurrentFile = this.screenFolder.getFile((IPath)p);
            String fileName = this.getFileName();
            openPath = aurora.plugin.source.gen.Util.getNewLinkFilePath((String)openPath, (String)fileName);
            p = new Path(openPath);
            IFile newFile = this.getNewFile((IPath)p);
            CompositeMap loadFile = CompositeMapUtil.loadFile((IFile)fCurrentFile);
            if (loadFile == null) {
                return;
            }
            try {
                BuilderSession session = this.gm.createBuilderSession();
                session.addConfig("be_opened_from_another", (Object)true);
                session.addConfig("para_name", (Object)para_name);
                session.addConfig("para_value", (Object)para_value);
                session.addConfig("file_name", (Object)this.getFileName(fCurrentFile));
                String genFile = sgm.buildScreen(loadFile, session).toXML();
                this.genNewFile(newFile, genFile);
                this.genRelation(sgm, loadFile, i);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private IProject getAuroraProject() {
        AuroraMetaProject amp = new AuroraMetaProject(this.project);
        try {
            return amp.getAuroraProject();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    private IFolder getScreenFolder() {
        AuroraMetaProject amp = new AuroraMetaProject(this.project);
        try {
            return amp.getScreenFolder();
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    private IContainer getAuroraWebFolder() {
        IContainer findWebInf = Util.findWebInf((IResource)this.auroraProject);
        return findWebInf == null ? null : findWebInf.getParent();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private IFile getNewFile(IFile file) {
        IPath makeRelativeTo = file.getProjectRelativePath().makeRelativeTo(this.screenFolder.getProjectRelativePath());
        return this.getNewFile(makeRelativeTo);
    }

    private IFile getNewFile(IPath makeRelativeTo) {
        makeRelativeTo = makeRelativeTo.removeFileExtension();
        makeRelativeTo = makeRelativeTo.addFileExtension("screen");
        return this.auroraWebFolder.getFile(makeRelativeTo);
    }
}

