/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.template.handle.TemplateHelper;
import aurora.ide.meta.gef.editors.wizard.dialog.TComposite;
import aurora.ide.meta.gef.i18n.Messages;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewWizardPage
extends WizardPage {
    private Text txtPath;
    private Text txtFile;
    private Template template;
    private IProject metaProject;
    private IResource metaFolder;
    private Label lblDesc;
    private boolean isNoTemplate;
    private Group composite;
    private TemplateHelper helper;

    public NewWizardPage(TemplateHelper helper) {
        super("aurora.wizard.new.Page");
        this.helper = helper;
        this.setTitle(Messages.NewWizardPage_Title);
        this.setDescription(Messages.NewWizardPage_Desc);
        this.setPageComplete(false);
        this.initMetaFolder();
    }

    private void initMetaFolder() {
        IResource r = this.getMetaFolderBySelection();
        if (r == null) {
            r = this.getMetaProjectByEditor();
        } else if (r instanceof IFile) {
            r = ((IFile)r).getParent();
        }
        if (r instanceof IFolder && r.getLocation().toString().indexOf("ui_prototype") < 0) {
            r = r.getProject();
        }
        this.metaFolder = r;
    }

    private IResource getMetaFolderBySelection() {
        IResource r = null;
        try {
            StructuredSelection ts;
            ISelection obj = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
            if (obj instanceof StructuredSelection && !(ts = (StructuredSelection)obj).isEmpty() && ts.getFirstElement() instanceof IResource && this.helper.isMetaProject(r = (IResource)ts.getFirstElement())) {
                return r;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private IProject getMetaProjectByEditor() {
        IResource r = null;
        try {
            r = (IResource)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput().getAdapter(IFile.class);
        }
        catch (NullPointerException e) {
            return null;
        }
        if (r == null) {
            return null;
        }
        if (this.helper.isMetaProject(r)) {
            return r.getProject();
        }
        return null;
    }

    private void createText(Composite composite) {
        Composite container = new Composite(composite, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(768));
        Label lbl = new Label(container, 0);
        lbl.setText(Messages.NewWizardPage_Folder);
        this.txtPath = new Text(container, 2048);
        this.txtPath.setLayoutData((Object)new GridData(768));
        Button btn = new Button(container, 0);
        btn.setText(Messages.NewWizardPage_Exploer);
        lbl = new Label(container, 0);
        lbl.setText(Messages.NewWizardPage_FileName);
        this.txtFile = new Text(container, 2048);
        this.txtFile.setLayoutData((Object)new GridData(768));
        this.txtPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWizardPage.this.textChanged();
            }
        });
        this.txtFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewWizardPage.this.textChanged();
            }
        });
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContainerSelectionDialog dialog = new ContainerSelectionDialog(NewWizardPage.this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot().getProject(), true, "");
                dialog.setTitle(Messages.NewWizardPage_folder_4);
                if (dialog.open() == 0 && dialog.getResult().length != 0) {
                    String path = dialog.getResult()[0].toString();
                    IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                    if (NewWizardPage.this.setPath(container)) {
                        NewWizardPage.this.txtFile.setFocus();
                    } else {
                        NewWizardPage.this.txtPath.setText(path);
                    }
                }
            }
        });
    }

    private boolean setPath(IResource container) {
        String path = "";
        if (container instanceof IProject) {
            IResource r = ((IProject)container).findMember("ui_prototype");
            if (r != null) {
                path = String.valueOf(r.getProject().getName()) + "/" + r.getProjectRelativePath().toString();
                this.txtPath.setText(path);
                return true;
            }
        } else if (container instanceof IFolder && this.helper.isMetaProject(container) && container.getProjectRelativePath().toString().indexOf("ui_prototype") >= 0) {
            path = String.valueOf(container.getProject().getName()) + "/" + container.getProjectRelativePath().toString();
            this.txtPath.setText(path);
            return true;
        }
        return false;
    }

    private void createTemplate(Composite composite, Map<String, List<Template>> tempMap) {
        TComposite tComposite = new TComposite(composite, 2048, tempMap);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        tComposite.setLayoutData(gd);
        this.template = tComposite.getSelection();
        tComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TComposite t = (TComposite)((Object)e.getSource());
                NewWizardPage.this.template = t.getSelection();
                if (NewWizardPage.this.template == null) {
                    return;
                }
                NewWizardPage.this.setTemplateDescription(NewWizardPage.this.template.getDescription());
            }
        });
        composite.layout(true);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        this.createText(container);
        final Button cc = new Button(container, 32);
        cc.setText("\u4e0d\u4f7f\u7528\u6478\u7248");
        cc.setLayoutData((Object)new GridData(768));
        cc.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewWizardPage.this.setNoTemplate(cc.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.composite = new Group(container, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.composite.setLayoutData((Object)new GridData(1808));
        this.composite.setText(Messages.NewWizardPage_Template);
        IPath path = MetaPlugin.getDefault().getStateLocation().append("template");
        this.createTemplate((Composite)this.composite, this.helper.getTemplates(path));
        if (this.setPath(this.metaFolder)) {
            this.txtFile.setFocus();
            this.updateStatus(null);
            this.setPageComplete(false);
        }
        this.lblDesc = new Label(container, 64);
        this.lblDesc.setLayoutData((Object)new GridData(768));
        if (this.template != null) {
            this.setTemplateDescription(this.template.getDescription());
        }
    }

    public String getPath() {
        return this.txtPath.getText().trim();
    }

    public String getFileName() {
        String fileName = this.txtFile.getText().trim();
        if (fileName.length() > 0 && fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + ".uip";
        }
        return fileName;
    }

    private void textChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getPath()));
        String fileName = this.getFileName();
        int dotLoc = fileName.lastIndexOf(46);
        if (this.getPath().length() == 0) {
            this.updateStatus(Messages.NewWizardPage_folder);
        } else if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(Messages.NewWizardPage_folder_2);
        } else if (!container.isAccessible()) {
            this.updateStatus(Messages.NewWizardPage_Project);
        } else if (!this.helper.isMetaProject(container)) {
            this.updateStatus(Messages.NewWizardPage_Project_2);
        } else if (this.getPath().lastIndexOf("ui_prototype") == -1) {
            this.updateStatus(Messages.NewWizardPage__folder_3);
        } else {
            this.metaProject = container.getProject();
            if (fileName != null && !fileName.equals("") && ((IContainer)container).getFile((IPath)new Path(fileName)).exists()) {
                this.updateStatus(Messages.NewWizardPage_File);
            } else if (fileName.length() == 0) {
                this.updateStatus(Messages.NewWizardPage_File_1);
            } else if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
                this.updateStatus(Messages.NewWizardPage_File_2);
            } else if (dotLoc != -1 && !fileName.substring(dotLoc + 1).equalsIgnoreCase("uip")) {
                this.updateStatus(Messages.NewWizardPage_File_3);
            } else {
                this.updateStatus(null);
            }
            return;
        }
        this.metaProject = null;
    }

    private void setTemplateDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.lblDesc.setText(desc);
        this.lblDesc.getParent().layout();
    }

    public void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IProject getMetaProject() {
        return this.metaProject;
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean isNoTemplate() {
        return this.isNoTemplate;
    }

    public void setNoTemplate(boolean isNoTemplate) {
        this.isNoTemplate = isNoTemplate;
    }
}

