/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard;

import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.handle.TemplateConfig;
import aurora.ide.meta.gef.editors.template.handle.TemplateFactory;
import aurora.ide.meta.gef.editors.template.handle.TemplateHandle;
import aurora.ide.meta.gef.editors.wizard.dialog.SelectModelDialog;
import aurora.ide.meta.gef.i18n.Messages;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectModelWizardPage
extends WizardPage {
    private ScreenBody viewDiagram;
    private TemplateConfig config;
    private Composite composite;
    private IPath bmPath;
    private boolean modify = false;

    public SelectModelWizardPage() {
        super("aurora.wizard.select.Page");
        this.setTitle(Messages.SettingWizardPage_Title);
        this.setDescription(Messages.SettingWizardPage_Model_Bind);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.composite);
    }

    public void setBMPath(IProject metaProject) {
        AuroraMetaProject metaPro = new AuroraMetaProject(metaProject);
        try {
            if (metaPro == null || metaPro.getAuroraProject() == null) {
                this.bmPath = null;
                return;
            }
            IProject auroraPro = metaPro.getAuroraProject();
            if (auroraPro.hasNature("aurora.ide.auroranature")) {
                this.bmPath = new Path(auroraPro.getPersistentProperty(ProjectPropertyPage.BMQN));
                return;
            }
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.bmPath = null;
    }

    public void createDynamicTextComponents(ScreenBody viewDiagram, TemplateConfig config) {
        this.viewDiagram = viewDiagram;
        this.config = config;
        this.setPageComplete(false);
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
        if (config.get("bm") != null && config.get("bm").size() > 0) {
            Group compoModel = new Group(this.composite, 0);
            compoModel.setLayout((Layout)new GridLayout(3, false));
            compoModel.setLayoutData((Object)new GridData(768));
            compoModel.setText("Model");
            for (Object bm : config.get("bm")) {
                this.createTextField((Composite)compoModel, (BMReference)bm);
            }
            compoModel.layout();
        } else {
            this.fillViewDiagram();
            this.setPageComplete(true);
            this.modify = true;
        }
        if (config.get("initBm") != null && config.get("initBm").size() > 0) {
            Group compoInitModel = new Group(this.composite, 0);
            compoInitModel.setLayout((Layout)new GridLayout(3, false));
            compoInitModel.setLayoutData((Object)new GridData(768));
            compoInitModel.setText(Messages.SelectModelWizardPage_InitModel);
            for (Object bm : config.get("initBm")) {
                this.createTextField((Composite)compoInitModel, (BMReference)bm);
            }
            compoInitModel.layout();
        }
        this.composite.layout();
    }

    private void createTextField(Composite composite, final BMReference bm) {
        Label lbl = new Label(composite, 0);
        lbl.setText(bm.getName());
        final Text txt = new Text(composite, 2048);
        txt.setLayoutData((Object)new GridData(768));
        Button btn = new Button(composite, 0);
        btn.setText(Messages.SettingWizardPage_Select_model);
        if (this.bmPath == null) {
            btn.setEnabled(false);
        }
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (txt.getText() == null || "".equals(txt.getText())) {
                    SelectModelWizardPage.this.setErrorMessage(null);
                    bm.setModel(null);
                    SelectModelWizardPage.this.setPageComplete(SelectModelWizardPage.this.checkFinish());
                    return;
                }
                IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(txt.getText());
                if (r == null || !r.exists()) {
                    SelectModelWizardPage.this.updateStatus(Messages.SelectModelWizardPage_FileNotExist);
                    return;
                }
                if (!(r instanceof IFile) || !r.getFileExtension().equalsIgnoreCase("bm")) {
                    SelectModelWizardPage.this.updateStatus(Messages.SelectModelWizardPage_MustSelectBm);
                    return;
                }
                if (!r.equals((Object)bm.getModel())) {
                    SelectModelWizardPage.this.modify = true;
                }
                bm.setModel((IFile)r);
                if (SelectModelWizardPage.this.checkFinish()) {
                    SelectModelWizardPage.this.fillViewDiagram();
                    SelectModelWizardPage.this.updateStatus(null);
                } else {
                    SelectModelWizardPage.this.setPageComplete(false);
                }
            }
        });
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource folder = ResourcesPlugin.getWorkspace().getRoot().findMember(SelectModelWizardPage.this.bmPath);
                SelectModelDialog dialog = new SelectModelDialog(SelectModelWizardPage.this.getShell(), folder);
                if (dialog.open() == 0 && dialog.getResult() instanceof IFile) {
                    txt.setText(((IFile)dialog.getResult()).getFullPath().toString());
                }
            }
        });
    }

    private boolean checkFinish() {
        for (Object bm : this.config.get("bm")) {
            if (((BMReference)bm).getModel() != null) continue;
            return false;
        }
        return true;
    }

    private void fillViewDiagram() {
        TemplateHandle handle = TemplateFactory.getTemplateHandle(this.viewDiagram.getTemplateType(), this.config);
        if (handle != null) {
            handle.fill(this.viewDiagram);
        }
    }

    public void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public ScreenBody getViewDiagram() {
        return this.viewDiagram;
    }

    public IWizardPage getNextPage() {
        if (this.config.get("grid") != null && this.config.get("grid").size() > 0 || this.config.get("link") != null && this.config.get("link").size() > 0) {
            return super.getNextPage();
        }
        return null;
    }

    public boolean isModify() {
        return this.modify;
    }

    public void setModify(boolean modify) {
        this.modify = modify;
    }
}

