/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard.dialog;

import aurora.ide.meta.gef.editors.wizard.dialog.MappingDialog;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Mapping;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingComposite
extends Composite {
    private TableViewer paraViewer;
    private Mapping c_mapping;
    private List<Mapping> input = new ArrayList<Mapping>();
    private AuroraComponent context;

    public MappingComposite(Composite parent, int style, AuroraComponent context) {
        super(parent, style);
        this.createControl();
        this.context = context;
    }

    private void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.paraViewer = new TableViewer((Composite)this, 67588);
        this.paraViewer.setContentProvider((IContentProvider)new MappingContentProvider());
        this.paraViewer.setLabelProvider((IBaseLabelProvider)new MappingLabelProvider());
        Table table = this.paraViewer.getTable();
        TableColumn column = new TableColumn(table, 0);
        column.setText("From");
        column.setWidth(100);
        column = new TableColumn(table, 0);
        column.setText("To");
        column.setWidth(100);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData layoutData = new GridData(1808);
        table.setLayoutData((Object)layoutData);
        Composite bs = new Composite((Composite)this, 0);
        bs.setLayout((Layout)new GridLayout());
        Button add = new Button(bs, 0);
        add.setText(" New  ");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog pd = new MappingDialog(MappingComposite.this.getShell(), null, MappingComposite.this.context);
                int open = pd.open();
                if (open == 0) {
                    Mapping mapping = pd.getMapping();
                    MappingComposite.this.input.add(mapping);
                    MappingComposite.this.paraViewer.setInput((Object)MappingComposite.this.input);
                }
            }
        });
        final Button edit = new Button(bs, 0);
        edit.setText("  Edit  ");
        edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingDialog pd = new MappingDialog(MappingComposite.this.getShell(), MappingComposite.this.c_mapping, MappingComposite.this.context);
                int open = pd.open();
                if (open == 0) {
                    Mapping mapping = pd.getMapping();
                    MappingComposite.this.c_mapping.setFrom(mapping.getFrom());
                    MappingComposite.this.c_mapping.setTo(mapping.getTo());
                    MappingComposite.this.paraViewer.refresh((Object)MappingComposite.this.c_mapping);
                }
            }
        });
        final Button del = new Button(bs, 0);
        del.setText("Delete");
        edit.setEnabled(false);
        del.setEnabled(false);
        this.paraViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    List list = ss.toList();
                    edit.setEnabled(list.size() == 1);
                    del.setEnabled(list.size() > 0);
                    MappingComposite.this.c_mapping = list.size() > 0 ? (Mapping)list.get(0) : null;
                }
            }
        });
        del.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingComposite.this.input.remove(MappingComposite.this.c_mapping);
                MappingComposite.this.paraViewer.setInput((Object)MappingComposite.this.input);
            }
        });
    }

    public void setMappings(List<Mapping> paras) {
        if (paras != null) {
            for (Mapping p : paras) {
                this.input.add(p.clone());
            }
        }
        this.paraViewer.setInput(this.input);
    }

    public List<Mapping> getMappings() {
        return this.input;
    }

    class MappingContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray(new Mapping[((List)inputElement).size()]);
            }
            return null;
        }
    }

    class MappingLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        private Color COLOR_ODD = new Color(null, 245, 255, 255);
        private Color COLOR_EVEN = new Color(null, 255, 255, 255);
        private int columnNumIndx = 1;

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == this.columnNumIndx) {
                return new Color(null, 128, 128, 128);
            }
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            int rowNum = MappingComposite.this.input.indexOf((Mapping)element);
            return rowNum % 2 == 0 ? this.COLOR_EVEN : this.COLOR_ODD;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Mapping) {
                if (columnIndex == 0) {
                    return ((Mapping)element).getFrom();
                }
                if (1 == columnIndex) {
                    return ((Mapping)element).getTo();
                }
            }
            return "";
        }
    }
}

