/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.js;

import aurora.ide.meta.js.RhinoClassShutter;
import aurora.ide.meta.js.RhinoWrapFactory;
import aurora.ide.meta.js.StopRunningException;
import aurora.ide.meta.js.object.CompositeMapObject;
import java.lang.reflect.InvocationTargetException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import uncertain.composite.CompositeMap;

public class ScriptEngine {
    private static ImporterTopLevel topLevel;
    private int optimizeLevel = -1;

    static {
        RhinoException.useMozillaStackStyle((boolean)false);
        ScriptEngine.initTopLevel(Context.enter());
        Context.exit();
        ContextFactory.initGlobal((ContextFactory)new ContextFactory(){

            protected Context makeContext() {
                Context cx = super.makeContext();
                cx.setLanguageVersion(180);
                cx.setOptimizationLevel(-1);
                cx.setClassShutter(RhinoClassShutter.getInstance());
                cx.setWrapFactory(RhinoWrapFactory.getInstance());
                return cx;
            }
        });
    }

    public void defineObject(Context cx, Scriptable scope, Object object, String className, String varName) {
        Scriptable ctx = cx.newObject((Scriptable)topLevel, className, new Object[]{object});
        ScriptableObject.defineProperty((Scriptable)topLevel, (String)varName, (Object)ctx, (int)1);
    }

    private static void initTopLevel(Context cx) {
        topLevel = new ImporterTopLevel(cx);
        try {
            ScriptableObject.defineClass((Scriptable)topLevel, CompositeMapObject.class);
            topLevel.defineFunctionProperties(new String[]{"print", "println"}, ScriptEngine.class, 2);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Scriptable createScope(CompositeMap xmlMap) {
        Context cx = Context.enter();
        Scriptable scope = cx.newObject((Scriptable)topLevel);
        scope.setParentScope(null);
        scope.setPrototype((Scriptable)topLevel);
        this.defineObject(cx, scope, xmlMap, "CompositeMap", "context");
        cx.evaluateString(scope, "var parser = new Packages.aurora.ide.meta.gef.editors.source.gen.core.UIPParser(context.getData());", "parser", 1, null);
        Context.exit();
        return scope;
    }

    public Object eval(String source, Scriptable scope) throws Exception {
        Object ret;
        block9: {
            ret = null;
            Context cx = Context.enter();
            try {
                try {
                    cx.setOptimizationLevel(this.optimizeLevel);
                    Script scr = cx.compileString(String.valueOf(source) + " run(context); ", "aa", 1, null);
                    ret = scr == null ? null : scr.exec(cx, scope);
                }
                catch (RhinoException re) {
                    if (!(re.getCause() instanceof StopRunningException)) {
                        throw re;
                    }
                    Context.exit();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
            Context.exit();
        }
        if (ret instanceof Wrapper) {
            ret = ((Wrapper)ret).unwrap();
        } else if (ret instanceof Undefined) {
            ret = null;
        }
        return ret;
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            System.out.print(s);
            ++i;
        }
    }

    public static void println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ScriptEngine.print(cx, thisObj, args, funObj);
        System.out.println();
    }

    public void setOptimizeLevel(int level) {
        this.optimizeLevel = level;
    }
}

