/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.project;

import aurora.ide.AuroraProjectNature;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.project.MetaProjectPropertyPage;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import uncertain.composite.CompositeMap;

public class AuroraMetaProject {
    private static final String CONFIG_FILE_NAME = ".prototype";
    private IProject project;
    private static final String UIP_HOME = "ui_prototype";
    private static final String MODEL_HOME = "model_prototype";
    private static final String AURORA_PROJECT = "aurora_project";

    public AuroraMetaProject(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IFolder getScreenFolder() throws ResourceNotFoundException {
        return this.getFolder(UIP_HOME);
    }

    public IFolder getModelFolder() throws ResourceNotFoundException {
        return this.getFolder(MODEL_HOME);
    }

    public IFile getNewScreenFile(IFile file) throws ResourceNotFoundException {
        IFolder screenFolder = this.getScreenFolder();
        IPath makeRelativeTo = file.getProjectRelativePath().makeRelativeTo(screenFolder.getProjectRelativePath());
        return this.getNewScreenFile(makeRelativeTo);
    }

    private IFile getNewScreenFile(IPath makeRelativeTo) throws ResourceNotFoundException {
        makeRelativeTo = makeRelativeTo.removeFileExtension();
        makeRelativeTo = makeRelativeTo.addFileExtension("screen");
        IContainer auroraWebFolder = this.getAuroraWebFolder();
        return auroraWebFolder.getFile(makeRelativeTo);
    }

    private IContainer getAuroraWebFolder() throws ResourceNotFoundException {
        IProject auroraProject = this.getAuroraProject();
        IContainer findWebInf = Util.findWebInf((IResource)auroraProject);
        return findWebInf == null ? null : findWebInf.getParent();
    }

    public IProject getAuroraProject() throws ResourceNotFoundException {
        String name = this.getPersistentProperty(AURORA_PROJECT);
        if ("".equals(name)) {
            try {
                IProject project2 = this.getProject();
                if (project2 != null) {
                    name = project2.getPersistentProperty(MetaProjectPropertyPage.AURORA_PROJECT_QN);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (name == null || "".equals(name)) {
            throw new ResourceNotFoundException();
        }
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            if (p.exists() && AuroraProjectNature.hasAuroraNature((IProject)p)) {
                return p;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        throw new ResourceNotFoundException();
    }

    public void setUIPFolder(String folderName) {
        this.setPersistentProperty(UIP_HOME, folderName);
    }

    public void setModelFolder(String folderName) {
        this.setPersistentProperty(MODEL_HOME, folderName);
    }

    public void setAuroraProject(String name) {
        this.setPersistentProperty(AURORA_PROJECT, name);
    }

    public IFolder getFolder(String key) throws ResourceNotFoundException {
        IFolder folder;
        String name = this.getPersistentProperty(key);
        if ("".equals(name) || name == null) {
            name = key;
        }
        if ((folder = this.project.getFolder(name)).exists()) {
            return folder;
        }
        throw new ResourceNotFoundException();
    }

    private String getPersistentProperty(String key) throws ResourceNotFoundException {
        IProject project2 = this.getProject();
        if (project2 == null || !project2.exists()) {
            return "";
        }
        IFile config = project2.getFile(CONFIG_FILE_NAME);
        if (config.exists()) {
            try {
                CompositeMap map = CacheManager.getCompositeMap((IFile)config);
                return map.getString((Object)key, "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String setPersistentProperty(String key, String value) {
        IFile config = this.getProject().getFile(CONFIG_FILE_NAME);
        CompositeMap map = new CompositeMap("config");
        if (config.exists()) {
            try {
                CompositeMap _map = CacheManager.getCompositeMap((IFile)config);
                map.copy(_map);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        map.put((Object)key, (Object)value);
        try {
            this.genNewFile(config, map.toXML());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return key;
    }

    private void genNewFile(IFile newFile, String content) throws ExecutionException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (is == null) {
            return;
        }
        if (newFile.exists()) {
            try {
                newFile.setContents((InputStream)is, true, false, null);
                return;
            }
            catch (CoreException e1) {
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        CreateFileOperation cfo = new CreateFileOperation(newFile, null, is, "create file."){

            protected void setResourceDescriptions(ResourceDescription[] descriptions) {
                super.setResourceDescriptions(descriptions);
            }

            public IStatus computeExecutionStatus(IProgressMonitor monitor) {
                IStatus status = super.computeExecutionStatus(monitor);
                if (status.isOK()) {
                    status = this.computeCreateStatus(false);
                }
                return status;
            }
        };
        cfo.execute(null, WorkspaceUndoUtil.getUIInfoAdapter((Shell)Display.getDefault().getActiveShell()));
    }
}

