/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.demonstrate;

import aurora.ide.editor.editorInput.PathEditorInput;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.wizard.dialog.DemonstratingDialog;
import aurora.ide.prototype.consultant.demonstrate.DemonstrateEditorMode;
import aurora.ide.prototype.consultant.demonstrate.Messages;
import aurora.plugin.source.gen.screen.model.DemonstrateData;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ButtonDemonstrating {
    private ComponentPart part;

    public ButtonDemonstrating(ComponentPart part) {
        this.part = part;
    }

    public void demonstrating(Shell shell) {
        DemonstrateData dd = (DemonstrateData)this.part.getComponent().getPropertyValue("demonstrate_data");
        if (dd == null) {
            EditorMode editorMode = this.part.getEditorMode();
            if (editorMode instanceof DemonstrateEditorMode) {
                this.showMessage(Messages.ButtonDemonstrating_0);
            } else {
                this.showMessage(Messages.ButtonDemonstrating_0);
            }
        } else if ("open_message".equals(dd.getOpenType())) {
            this.showMessage(dd.getOpenMessage());
        } else if ("open_type_uip".equals(dd.getOpenType())) {
            this.openUIP(dd.getOpenUIPPath());
        }
    }

    private void showMessage(String msg) {
        DialogUtil.showWarningMessageBox((String)msg);
    }

    private void openUIP(String path) {
        IPath afp = this.getActiveEditorFile();
        Path p = new Path(path);
        File file = p.toFile();
        if (!file.isFile()) {
            file = afp.append((IPath)p).toFile();
        }
        if (!file.isFile()) {
            this.showMessage(Messages.ButtonDemonstrating_1);
            return;
        }
        EditorMode editorMode = this.part.getEditorMode();
        if (editorMode instanceof DemonstrateEditorMode) {
            DemonstratingDialog demonstratingDialog = ((DemonstrateEditorMode)editorMode).getDemonstratingDialog();
            demonstratingDialog.setInput(file);
            return;
        }
        IEditorInput input = this.createEditorInput(file);
        String editorId = this.getEditorId(file);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private IPath getActiveEditorFile() {
        EditorMode editorMode = this.part.getEditorMode();
        if (editorMode instanceof DemonstrateEditorMode) {
            DemonstratingDialog demonstratingDialog = ((DemonstrateEditorMode)editorMode).getDemonstratingDialog();
            return demonstratingDialog.getActiveFilePath();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorInput editorInput = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        if (editorInput instanceof PathEditorInput) {
            return ((PathEditorInput)editorInput).getPath();
        }
        return null;
    }

    private String getEditorId(File file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "aurora.ide.meta.gef.editors.ConsultantVScreenEditor";
    }

    private IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }
}

