/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.demonstrate;

import aurora.ide.meta.gef.editors.figures.InputField;
import aurora.ide.meta.gef.editors.figures.SimpleDataCellEditorLocator;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.prototype.consultant.demonstrate.ComboDirectEditManager;
import aurora.ide.prototype.consultant.demonstrate.DemonstrateDSManager;
import aurora.plugin.source.gen.screen.model.DemonstrateDS;
import aurora.plugin.source.gen.screen.model.DemonstrateData;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Shell;

public class ComboDemonstrating {
    private ComponentPart part;
    private String feature = "input_simple_data";

    public ComboDemonstrating(ComponentPart part) {
        this.part = part;
    }

    public void demonstrating(Shell shell) {
        ComboDirectEditManager manager = new ComboDirectEditManager((GraphicalEditPart)this.part, ComboBoxCellEditor.class, this.getCellEditorLocator(), this.feature);
        manager.setItem(this.parseItems());
        manager.show();
    }

    protected CellEditorLocator getCellEditorLocator() {
        return new SimpleDataCellEditorLocator((InputField)this.part.getFigure());
    }

    private String[] parseItems() {
        DemonstrateDS demonstrateDS;
        DemonstrateData dd = (DemonstrateData)this.part.getComponent().getPropertyValue("demonstrate_data");
        if (dd == null) {
            return new String[0];
        }
        String dsName = dd.getDemonstrateDSName();
        if (dsName != null && !"".equals(dsName) && (demonstrateDS = DemonstrateDSManager.getInstance().getDemonstrateDS(dsName)) != null) {
            return this.parseItems(demonstrateDS.getData());
        }
        String data = dd.getDemonstrateData();
        return this.parseItems(data);
    }

    private String[] parseItems(String demonstrateDS) {
        if (demonstrateDS == null || "".equals(demonstrateDS)) {
            return new String[0];
        }
        String result = demonstrateDS.replaceAll("\r", "");
        result = result.replaceAll("\n", "");
        return result.split(",");
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }
}

