/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.demonstrate;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboDirectEditManager
extends DirectEditManager {
    private Font scaledFont;
    protected VerifyListener verifyListener;
    protected IFigure nodeFigure;
    private String[] items = new String[0];

    public ComboDirectEditManager(GraphicalEditPart source, Class<?> editorType, CellEditorLocator locator, String feature) {
        super(source, editorType, locator, (Object)feature);
        this.nodeFigure = source.getFigure();
    }

    protected void initCellEditor() {
        Control control = this.getCellEditor().getControl();
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.nodeFigure.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        if (control instanceof CCombo) {
            CCombo text = (CCombo)control;
            text.setFont(this.scaledFont);
        }
    }

    protected boolean isDirty() {
        return this.getCellEditor().isDirty();
    }

    public void show() {
        super.show();
        Control control = this.getCellEditor().getControl();
        if (control instanceof CCombo) {
            CCombo text = (CCombo)control;
            text.setListVisible(true);
        }
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new ComboBoxCellEditor(composite, this.items){

            protected Object doGetValue() {
                return ((CCombo)this.getControl()).getText();
            }
        };
    }

    public void setItem(String[] items) {
        this.items = items;
    }
}

