/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.demonstrate;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.plugin.source.gen.screen.model.DemonstrateDS;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.composite.XMLOutputter;

public class DemonstrateDSManager {
    private static final String dsLocation = String.valueOf(System.getProperty("user.home")) + "/Aurora Quick UI/demonstrateDS.xml";
    private List<DemonstrateDS> demonstrateDS = new ArrayList<DemonstrateDS>();
    private static DemonstrateDSManager instance;

    public static DemonstrateDSManager getInstance() {
        return instance;
    }

    public static DemonstrateDSManager makeInstance() {
        instance = new DemonstrateDSManager();
        return instance;
    }

    public void loadDemonstrateDS() {
        if (!new File(dsLocation).exists()) {
            return;
        }
        CompositeMap loadFile = CompositeMapUtil.loadFile((File)new File(dsLocation));
        if (loadFile == null) {
            return;
        }
        loadFile.iterate(new IterationHandle(){

            public int process(CompositeMap map) {
                if ("DS".equals(map.getName())) {
                    DemonstrateDS ds = new DemonstrateDS(map.getChild("Name").getText(), map.getChild("Data").getText());
                    DemonstrateDSManager.this.demonstrateDS.add(ds);
                }
                return 0;
            }
        }, false);
    }

    public void saveDemonstrateDS() {
        File file = new File(dsLocation);
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            XMLOutputter.saveToFile((File)file, (CompositeMap)this.createCompositeMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private CompositeMap createCompositeMap() {
        CompositeMap map = new CompositeMap("List");
        for (DemonstrateDS ds : this.demonstrateDS) {
            CompositeMap dsMap = map.createChild("DS");
            dsMap.createChild("Name").setText(ds.getName());
            dsMap.createChild("Data").setText(ds.getData());
        }
        return map;
    }

    public DemonstrateDS[] getDemonstrateDS() {
        return this.demonstrateDS.toArray(new DemonstrateDS[this.demonstrateDS.size()]);
    }

    public DemonstrateDS getDemonstrateDS(String dsName) {
        for (DemonstrateDS ds : this.demonstrateDS) {
            if (!dsName.equals(ds.getName())) continue;
            return ds;
        }
        return null;
    }

    public void addDemonstrateDS(DemonstrateDS ds) {
        this.demonstrateDS.add(ds);
    }

    public void removeDemonstrateDS(DemonstrateDS ds) {
        this.demonstrateDS.remove(ds);
    }
}

