/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.config;

import aurora.application.config.BaseServiceConfig;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;

public class ScreenConfig
extends BaseServiceConfig {
    public static final String KEY_CONTENT_TYPE = "contenttype";
    public static final String KEY_CACHE_KEY = "cachekey";
    public static final String KEY_VIEW = "view";
    public static final String DEFAULT_CONTENT_TYPE = "text/html;charset=utf-8";

    public static ScreenConfig createScreenConfig(CompositeMap map) {
        ScreenConfig cfg = new ScreenConfig();
        cfg.initialize(map);
        return cfg;
    }

    public CompositeMap getViewConfig() {
        return this.object_context.getChild(KEY_VIEW);
    }

    public void addDataSet(CompositeMap ds) {
        CompositeMap datasets = this.getDataSetsConfig();
        if (datasets == null) {
            datasets = new CompositeMap("dataSets");
            datasets.setNameSpaceURI("http://www.aurora-framework.org/application");
            CompositeMap view = CompositeUtil.findChild((CompositeMap)this.getObjectContext(), (String)KEY_VIEW);
            view.addChild(0, datasets);
        }
        datasets.addChild(ds);
    }

    public CompositeMap getDataSetsConfig() {
        return CompositeUtil.findChild((CompositeMap)this.object_context, (String)"dataSets");
    }

    public boolean isCacheEnabled() {
        return this.getBoolean("cacheenabled", false);
    }

    public void setCacheEnabled(boolean e) {
        this.putBoolean("cacheenabled", e);
    }

    public String getCacheKey() {
        return this.getString(KEY_CACHE_KEY);
    }

    public void setCacheKey(String key) {
        this.putString(KEY_CACHE_KEY, key);
    }

    public String getContentType() {
        return this.getString(KEY_CONTENT_TYPE, DEFAULT_CONTENT_TYPE);
    }

    public void setContentType(String type) {
        this.putString(KEY_CONTENT_TYPE, type);
    }

    public void setTrace(boolean trace) {
        this.putBoolean("trace", trace);
    }

    public boolean isTrace() {
        return this.getBoolean("trace", false);
    }
}

