/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.features.ILookupCodeProvider;
import aurora.database.features.CacheBasedLookUpField;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.service.ServiceThreadLocal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.IGlobalInstance;
import uncertain.core.UncertainEngine;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.GeneralException;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class CacheBasedLookupCodeProvider
extends AbstractLocatableObject
implements ILookupCodeProvider,
IGlobalInstance {
    private static final String DEFAULT_SORT_FIELD = "code_value_id";
    private IObjectRegistry mRegistry;
    private INamedCacheFactory mCacheFactory;
    private String promptCacheName;
    private String listCacheName;
    private String promptCacheKey = "{0}.{1}.{2}";
    private String listCacheKey = "{0}.{1}";
    private String sortField;
    private ICache promptCache;
    private ICache listCache;

    public CacheBasedLookupCodeProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory) {
        this.mRegistry = registry;
        this.mCacheFactory = cacheFactory;
    }

    @Override
    public List getLookupList(String language, String lookup_code) throws Exception {
        List result = (List)this.listCache.getValue((Object)this.getFullListCacheKey(lookup_code, language));
        if (result != null) {
            this.sorList(result);
        }
        return result;
    }

    private void sorList(List result) {
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                CompositeMap r1 = (CompositeMap)arg0;
                CompositeMap r2 = (CompositeMap)arg1;
                String object1 = r1.getString((Object)CacheBasedLookupCodeProvider.this.getSortField());
                String object2 = r2.getString((Object)CacheBasedLookupCodeProvider.this.getSortField());
                return object1.compareTo(object2);
            }
        });
    }

    @Override
    public String getLookupPrompt(String language, String lookup_code, Object lookup_value) {
        Object prompt = this.promptCache.getValue((Object)this.getFullPromptCacheKey(lookup_code, lookup_value != null ? lookup_value.toString() : null, language));
        if (prompt != null) {
            return prompt.toString();
        }
        return null;
    }

    public void onInitialize() throws Exception {
        this.promptCache = this.mCacheFactory.getNamedCache(this.promptCacheName);
        if (this.promptCache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.promptCacheName}, (ILocatable)this);
        }
        this.listCache = this.mCacheFactory.getNamedCache(this.listCacheName);
        if (this.listCache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.listCacheName}, (ILocatable)this);
        }
        IDatabaseServiceFactory databaseServiceFactory = (IDatabaseServiceFactory)this.mRegistry.getInstanceOfType(IDatabaseServiceFactory.class);
        if (databaseServiceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IDatabaseServiceFactory.class);
        }
        if (!(databaseServiceFactory instanceof DatabaseServiceFactory)) {
            throw BuiltinExceptionFactory.createInstanceTypeWrongException((String)this.getOriginSource(), DatabaseServiceFactory.class, databaseServiceFactory.getClass());
        }
        IDatabaseFactory databaseFactory = (IDatabaseFactory)this.mRegistry.getInstanceOfType(IDatabaseFactory.class);
        if (databaseFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, IDatabaseFactory.class);
        }
        UncertainEngine uncertainEngine = (UncertainEngine)this.mRegistry.getInstanceOfType(UncertainEngine.class);
        if (uncertainEngine == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException((ILocatable)this, UncertainEngine.class);
        }
        CacheBasedLookUpField cacheBasedLookUpField = new CacheBasedLookUpField(databaseFactory, uncertainEngine.getObjectRegistry());
        ((DatabaseServiceFactory)databaseServiceFactory).setGlobalParticipant(cacheBasedLookUpField);
    }

    public String getSortField() {
        return this.sortField == null ? DEFAULT_SORT_FIELD : this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getFullListCacheKey(String code, String language) {
        String patten = TextParser.parse((String)this.listCacheKey, (CompositeMap)ServiceThreadLocal.getCurrentThreadContext());
        return MessageFormat.format(patten, code, language);
    }

    public String getFullPromptCacheKey(String code, String code_value, String language) {
        String patten = TextParser.parse((String)this.promptCacheKey, (CompositeMap)ServiceThreadLocal.getCurrentThreadContext());
        return MessageFormat.format(patten, code, code_value, language);
    }

    public String getListCacheName() {
        return this.listCacheName;
    }

    public void setListCacheName(String listCacheName) {
        this.listCacheName = listCacheName;
    }

    public String getPromptCacheName() {
        return this.promptCacheName;
    }

    public void setPromptCacheName(String promptCacheName) {
        this.promptCacheName = promptCacheName;
    }

    public String getListCacheKey() {
        return this.listCacheKey;
    }

    public void setListCacheKey(String listCacheKey) {
        this.listCacheKey = listCacheKey;
    }

    public String getPromptCacheKey() {
        return this.promptCacheKey;
    }

    public void setPromptCacheKey(String promptCacheKey) {
        this.promptCacheKey = promptCacheKey;
    }
}

