/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features;

import aurora.application.features.ILookupCodeProvider;
import aurora.database.FetchDescriptor;
import aurora.database.features.LookUpField;
import aurora.database.profile.IDatabaseFactory;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.service.ServiceThreadLocal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;

public class DefaultLookupCodeProvider
implements ILookupCodeProvider,
IGlobalInstance {
    private String lookupType = "sql";
    private String lookupSql;
    private String lookupModel;
    private String sortField;
    private String needCache;
    private DatabaseServiceFactory factory;
    private IObjectRegistry registry;
    private boolean inited = false;
    private List cache = new ArrayList();
    private Map cacheMap = new HashMap();
    private static final String DEFAULT_SORT_FIELD = "code_value_id";

    public DefaultLookupCodeProvider(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public List getLookupList(String language, String lookup_code) throws Exception {
        if ("sql".equals(this.lookupType)) {
            return this.getListFromDataBase(language, lookup_code);
        }
        return this.getListFromCache(language, lookup_code);
    }

    private List getListFromDataBase(String language, String lookup_code) throws Exception {
        List result = null;
        result = (ArrayList)this.cacheMap.get(lookup_code);
        if (result != null) {
            return result;
        }
        result = new ArrayList();
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        if (context == null) {
            throw new IllegalStateException("No service context set in ThreadLocal yet");
        }
        BusinessModelService service = this.factory.getModelService(this.getLookupModel(), context);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", lookup_code);
        map.put("language", language);
        CompositeMap resultMap = service.queryAsMap(map, FetchDescriptor.fetchAll());
        if (resultMap != null && (result = resultMap.getChilds()) != null) {
            this.sorList(result);
        }
        if ("true".equalsIgnoreCase(this.getNeedCache())) {
            this.cacheMap.put(lookup_code, result);
        }
        return result;
    }

    private List getListFromCache(String language, String lookup_code) {
        ArrayList<CompositeMap> result = new ArrayList<CompositeMap>();
        Iterator it = this.cache.iterator();
        if (lookup_code != null && language != null) {
            while (it.hasNext()) {
                CompositeMap record = (CompositeMap)it.next();
                String looupcode = record.getString((Object)"code");
                String lan = record.getString((Object)"language");
                if (!lookup_code.equals(looupcode) || !language.equals(lan)) continue;
                result.add(record);
            }
        }
        this.sorList(result);
        return result;
    }

    private void sorList(List result) {
        Collections.sort(result, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                CompositeMap r1 = (CompositeMap)arg0;
                CompositeMap r2 = (CompositeMap)arg1;
                Integer id1 = r1.getInt((Object)DefaultLookupCodeProvider.this.getSortField());
                Integer id2 = r2.getInt((Object)DefaultLookupCodeProvider.this.getSortField());
                return id1.compareTo(id2);
            }
        });
    }

    @Override
    public String getLookupPrompt(String language, String lookup_code, Object lookup_value) {
        return null;
    }

    public void onInitialize() throws Exception {
        this.factory = (DatabaseServiceFactory)this.registry.getInstanceOfType(DatabaseServiceFactory.class);
        IDatabaseFactory databaseFactory = (IDatabaseFactory)this.registry.getInstanceOfType(IDatabaseFactory.class);
        if (databaseFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IDatabaseFactory.class);
        }
        LookUpField lookUpField = new LookUpField(databaseFactory, this.registry);
        this.factory.setGlobalParticipant(lookUpField);
        this.init();
    }

    public void invalid() throws Exception {
        this.inited = false;
        this.cache = new ArrayList();
        this.init();
    }

    private void init() throws Exception {
        if (!"sql".equals(this.lookupType) && !this.inited) {
            SqlServiceContext context = this.factory.createContextWithConnection();
            try {
                BusinessModelService service = this.factory.getModelService(this.getLookupModel(), context.getObjectContext());
                CompositeMap resultMap = service.queryAsMap(new HashMap(), FetchDescriptor.fetchAll());
                if (resultMap != null) {
                    this.cache = resultMap.getChilds();
                }
                this.inited = true;
            }
            finally {
                if (context != null) {
                    context.freeConnection();
                }
            }
        }
    }

    public String getLookupType() {
        return this.lookupType;
    }

    public void setLookupType(String lookupType) {
        this.lookupType = lookupType;
    }

    public String getLookupSql() {
        return this.lookupSql;
    }

    public void setLookupSql(String lookupSql) {
        this.lookupSql = lookupSql;
    }

    public String getLookupModel() {
        return this.lookupModel;
    }

    public void setLookupModel(String lookupModel) {
        this.lookupModel = lookupModel;
    }

    public String getSortField() {
        return this.sortField == null ? DEFAULT_SORT_FIELD : this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getNeedCache() {
        return this.needCache;
    }

    public void setNeedCache(String needCache) {
        this.needCache = needCache;
    }
}

