/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.cache;

import aurora.application.features.cache.CacheProvider;
import aurora.bm.ICachedDataProvider;
import aurora.bm.IModelFactory;
import java.util.Timer;
import java.util.TimerTask;
import uncertain.cache.INamedCacheFactory;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class PeriodModeCacheProvider
extends CacheProvider {
    protected int refreshInterval = 3600000;

    public PeriodModeCacheProvider(IObjectRegistry registry, INamedCacheFactory cacheFactory, ICachedDataProvider cacheDataProvider, IModelFactory modelFactory) {
        super(registry, cacheFactory, cacheDataProvider, modelFactory);
    }

    @Override
    public void initialize() {
        if (this.refreshInterval == -1) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"refreshInterval");
        }
        super.initialize();
    }

    @Override
    protected void initReloadTimer() {
        this.reloadTimer = new Timer(String.valueOf(this.getCacheName()) + "_reload_timer");
        TimerTask timerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!PeriodModeCacheProvider.this.shutdown) {
                    Object object = PeriodModeCacheProvider.this.reloadLock;
                    synchronized (object) {
                        try {
                            PeriodModeCacheProvider.this.reloadLock.wait(PeriodModeCacheProvider.this.refreshInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!PeriodModeCacheProvider.this.shutdown) {
                            PeriodModeCacheProvider.this.reloadWithTrx();
                        }
                    }
                }
            }
        };
        this.reloadTimer.schedule(timerTask, 0L);
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }
}

