/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageStub;
import aurora.events.E_TransactionCommit;
import aurora.events.E_TransactionRollBack;
import aurora.service.ServiceThreadLocal;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import uncertain.composite.CompositeMap;
import uncertain.event.RuntimeContext;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IObjectRegistry;

public class TrxMessageDispatcher
implements E_TransactionCommit,
E_TransactionRollBack,
IMessageDispatcher {
    protected IObjectRegistry mRegistry;
    protected String topic;
    private Queue<MessageEntity> msgQueue = new ConcurrentLinkedQueue<MessageEntity>();

    public TrxMessageDispatcher(IObjectRegistry registry) {
        this.mRegistry = registry;
        CompositeMap context = ServiceThreadLocal.getCurrentThreadContext();
        RuntimeContext.getInstance((CompositeMap)context).setInstanceOfType(IMessageDispatcher.class, (Object)this);
    }

    protected IMessageDispatcher createMessageDispatcher() {
        IMessageStub messageStub = (IMessageStub)this.mRegistry.getInstanceOfType(IMessageStub.class);
        if (messageStub == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IMessageStub.class, (String)this.getClass().getCanonicalName());
        }
        return messageStub.getDispatcher();
    }

    @Override
    public int onTransactionRollBack() {
        this.msgQueue.clear();
        return 0;
    }

    @Override
    public int onTransactionCommit() {
        if (this.msgQueue == null || this.msgQueue.isEmpty()) {
            return 0;
        }
        IMessageDispatcher dispatcher = this.createMessageDispatcher();
        for (MessageEntity me : this.msgQueue) {
            try {
                dispatcher.send(me.getTopic(), me.getMessage(), me.getContext());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.msgQueue.clear();
        return 0;
    }

    @Override
    public void send(String topic, IMessage message, CompositeMap context) throws Exception {
        MessageEntity me = new MessageEntity(topic, message, context);
        this.msgQueue.add(me);
    }

    class MessageEntity {
        String topic;
        IMessage message;
        CompositeMap context;

        public MessageEntity(String topic, IMessage message, CompositeMap context) {
            this.topic = topic;
            this.message = message;
            this.context = context;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public IMessage getMessage() {
            return this.message;
        }

        public void setMessage(IMessage message) {
            this.message = message;
        }

        public CompositeMap getContext() {
            return this.context;
        }

        public void setContext(CompositeMap context) {
            this.context = context;
        }
    }
}

