/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.actions;

import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.database.service.ServiceOption;
import aurora.database.service.SqlServiceContext;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public abstract class AbstractModelAction
extends AbstractEntry {
    String mModel;
    DatabaseServiceFactory mServiceFactory;
    BusinessModelService mService;
    ILogger mLogger;
    CompositeMap mEntryConfig;

    public AbstractModelAction(DatabaseServiceFactory svcFactory) {
        this.mServiceFactory = svcFactory;
    }

    protected void transferServiceOption(ServiceOption option, String key) {
        if (this.mEntryConfig != null) {
            option.getObjectContext().put((Object)key, this.mEntryConfig.get((Object)key));
        }
    }

    protected void prepareServiceOption(ServiceOption option) {
    }

    protected void prepareRun(CompositeMap context_map) throws Exception {
        if (this.mModel == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"model");
        }
        SqlServiceContext context = (SqlServiceContext)((Object)DynamicObject.cast((CompositeMap)context_map, SqlServiceContext.class));
        this.mService = this.mServiceFactory.getModelService(TextParser.parse((String)this.mModel, (CompositeMap)context_map), context_map);
        this.mLogger = DatabaseServiceFactory.getLogger(context_map);
        ServiceOption option = ServiceOption.createInstance();
        this.prepareServiceOption(option);
        context.setServiceOption(option);
    }

    public BusinessModelService getService() {
        return this.mService;
    }

    public DatabaseServiceFactory getServiceFactory() {
        return this.mServiceFactory;
    }

    public abstract void run(ProcedureRunner var1) throws Exception;

    public String getModel() {
        return this.mModel;
    }

    public void setModel(String model) {
        this.mModel = model;
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    public void beginConfigure(CompositeMap config) {
        super.beginConfigure(config);
        this.mEntryConfig = config;
    }

    public String getName() {
        return String.valueOf(super.getName()) + "[" + this.getModel() + "]";
    }
}

