/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.local.oracle;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.database.local.oracle.SequenceUse;
import aurora.database.local.oracle.sql.OracleInsertStatement;
import aurora.database.local.oracle.sql.ReturningIntoStatement;
import aurora.database.service.BusinessModelServiceContext;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.InsertStatement;
import aurora.service.validation.Parameter;
import java.util.LinkedList;
import java.util.List;
import uncertain.core.ConfigurationError;

public class SequencePk {
    String sequenceName;
    boolean autoReturn = true;
    List sequences = new LinkedList();

    public void onPrepareBusinessModel(BusinessModel model) {
        Field fld;
        if (this.sequences.size() == 0) {
            Field[] fields = model.getPrimaryKeyFields();
            if (fields.length == 1) {
                SequenceUse su = new SequenceUse();
                su.setAutoReturn(this.autoReturn);
                su.setFieldName(fields[0].getPhysicalName());
                if (this.sequenceName != null) {
                    su.setSequenceName(this.sequenceName);
                } else {
                    su.setSequenceName(String.valueOf(model.getBaseTable()) + "_S");
                }
                this.addSequenceUse(su);
            } else {
                int i = 0;
                while (i < fields.length) {
                    fld = fields[i];
                    SequenceUse su = new SequenceUse();
                    su.setAutoReturn(this.autoReturn);
                    su.setSequenceName(String.valueOf(fld.getPhysicalName()) + "_S");
                    su.setFieldName(fld.getPhysicalName());
                    this.addSequenceUse(su);
                    ++i;
                }
            }
        }
        for (SequenceUse su : this.sequences) {
            fld = model.getField(su.getFieldName());
            if (fld == null) {
                throw new ConfigurationError("Sequence generated field " + su.getFieldName() + " is not found");
            }
            if (fld.getString("insertexpression") != null) continue;
            fld.setInsertExpression(String.valueOf(su.getSequenceName()) + ".NEXTVAL");
        }
    }

    public void postPopulateInsertStatement(BusinessModelServiceContext bmsc, ISqlStatement stmt, BusinessModel bm) {
        if (!(stmt instanceof InsertStatement)) {
            return;
        }
        if (this.sequences == null) {
            return;
        }
        if (this.sequences.size() == 0) {
            return;
        }
        OracleInsertStatement ois = new OracleInsertStatement((InsertStatement)stmt);
        ReturningIntoStatement ris = new ReturningIntoStatement();
        for (SequenceUse su : this.sequences) {
            if (!su.getAutoReturn()) continue;
            String field_name = su.getFieldName();
            Field fld = bm.getField(field_name);
            ris.addField(field_name, Field.defaultParamExpression(fld.getParameterPath()));
            Parameter param = new Parameter();
            param.setDataType(fld.getDataType());
            param.setInput(false);
            param.setOutput(true);
            param.setOutputPath(fld.getParameterPath());
            param.setName(fld.getName());
            ois.addParameter(param);
        }
        if (ris.getFields().size() > 0) {
            ois.setReturningInto(ris);
            bmsc.setStatement(ois);
        }
    }

    public void addSequenceUse(SequenceUse su) {
        this.sequences.add(su);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public boolean getAutoReturn() {
        return this.autoReturn;
    }

    public void setAutoReturn(boolean autoReturn) {
        this.autoReturn = autoReturn;
    }

    public List getSequences() {
        return this.sequences;
    }

    public void setSequences(List sequences) {
        this.sequences = sequences;
    }
}

