/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.rsconsumer;

import aurora.database.rsconsumer.CompositeMapCreator;
import uncertain.cache.CacheBuiltinExceptionFactory;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.util.resource.ILocatable;

public class CacheWriter
extends CompositeMapCreator {
    INamedCacheFactory mCacheFactory;
    String mCacheName;
    String mRecordKey;
    ICache mCache;

    public CacheWriter(INamedCacheFactory mCacheFactory) {
        this.mCacheFactory = mCacheFactory;
    }

    public String getCacheName() {
        return this.mCacheName;
    }

    public void setCacheName(String cacheName) {
        this.mCacheName = cacheName;
    }

    public ICache getCache() {
        if (this.mCacheName == null) {
            return this.mCacheFactory.getCache();
        }
        return this.mCacheFactory.getNamedCache(this.mCacheName);
    }

    @Override
    public void endRow() {
        String key = TextParser.parse((String)this.mRecordKey, (CompositeMap)this.currentRecord);
        this.mCache.setValue((Object)key, (Object)this.currentRecord);
    }

    @Override
    public void begin(String root_name) {
        if (this.mRecordKey == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"recordKey");
        }
        this.mCache = this.getCache();
        if (this.mCache == null) {
            throw CacheBuiltinExceptionFactory.createNamedCacheNotFound((ILocatable)this, (String)this.mCacheName);
        }
    }

    public String getRecordKey() {
        return this.mRecordKey;
    }

    public void setRecordKey(String recordKey) {
        this.mRecordKey = recordKey;
    }
}

