/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.druid;

import aurora.datasource.DatabaseConnection;
import aurora.datasource.IDataSourceFactory;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.alibaba.druid.pool.DruidPooledConnection;
import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;

public class DataSourceFactory
implements IDataSourceFactory {
    @Override
    public DataSource createDataSource(DatabaseConnection dbConfig) throws Exception {
        Properties properties = dbConfig.getPoolProperties();
        DataSource ds = null;
        properties.put("username", dbConfig.getUserName());
        properties.put("password", dbConfig.getPassword());
        properties.put("driverClassName", dbConfig.getDriverClass());
        properties.put("url", dbConfig.getUrl());
        ds = DruidDataSourceFactory.createDataSource((Properties)properties);
        return ds;
    }

    @Override
    public void cleanDataSource(DataSource ds) {
        ((DruidDataSource)ds).close();
    }

    @Override
    public Connection getNativeJdbcExtractor(Connection conn) throws Exception {
        Connection nativeConn = conn;
        if (conn instanceof DruidPooledConnection) {
            DruidPooledConnection c = (DruidPooledConnection)conn;
            nativeConn = c.getConnection();
        }
        return nativeConn;
    }
}

