/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.ApplicationViewConfig;
import aurora.application.features.ILookupCodeProvider;
import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.DataSetConfig;
import aurora.presentation.component.std.config.DataSetFieldConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class DataSet
extends Component {
    public static final String VERSION = "$Revision: 8048 $";
    private static final String VALID_SCRIPT = "validscript";
    private IModelFactory mFactory;
    private ILookupCodeProvider lookupProvider;

    public DataSet(IObjectRegistry registry, IModelFactory factory, ILookupCodeProvider lookupProvider) {
        super(registry);
        this.mFactory = factory;
        this.lookupProvider = lookupProvider;
    }

    private void initLovService(String baseModel, BuildSession session, CompositeMap field) throws IOException {
        BusinessModel bm = null;
        bm = this.mFactory.getModelForRead(baseModel.split("\\?")[0]);
        Field[] bmfields = bm.getFields();
        JSONArray lovDisplayFields = new JSONArray();
        if (bmfields != null) {
            int i = 0;
            int l = bmfields.length;
            while (i < l) {
                Field f = bmfields[i];
                if (f.isForDisplay()) {
                    DataSetFieldConfig dfc = DataSetFieldConfig.getInstance(f.getObjectContext());
                    dfc.setPrompt(session.getLocalizedPrompt(dfc.getPrompt()));
                    lovDisplayFields.put((Object)new JSONObject((Map)dfc.getObjectContext()));
                }
                ++i;
            }
        }
        field.put((Object)"displayFields", (Object)lovDisplayFields);
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        String pf;
        ILookupCodeProvider provider;
        String lcode;
        Iterator it;
        ApplicationViewConfig view_config;
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        JSONArray fieldList = new JSONArray();
        int mDefaultPageSize = -1;
        boolean mDefaultModifiedCheck = true;
        boolean autoCount = true;
        if (this.mApplicationConfig != null && (view_config = this.mApplicationConfig.getApplicationViewConfig()) != null) {
            mDefaultPageSize = view_config.getDefaultPageSize();
            mDefaultModifiedCheck = view_config.getDefaultModifiedCheck();
            autoCount = view_config.getDefaultAutoCount();
        }
        view_config = this.mApplicationConfig.getApplicationViewConfig();
        DataSetConfig dsc = DataSetConfig.getInstance(view);
        CompositeMap fields = dsc.getFields();
        if (fields != null && (it = fields.getChildIterator()) != null) {
            while (it.hasNext()) {
                String returnField;
                String requiredMessage;
                String lovTitle;
                String lovUrl;
                String lovModel;
                String lovService;
                String options;
                boolean fuzzyFetch;
                CompositeMap field = (CompositeMap)it.next();
                DataSetFieldConfig sdfc = DataSetFieldConfig.getInstance(field);
                if (field.getString((Object)"required") != null) {
                    field.putBoolean((Object)"required", sdfc.getRequired(model));
                }
                if (field.getString((Object)"readonly") != null) {
                    field.putBoolean((Object)"readonly", sdfc.getReadOnly(model));
                }
                if (field.getString((Object)"editable") != null) {
                    field.putBoolean((Object)"editable", sdfc.getEditable(model));
                }
                if (field.getString((Object)"autocomplete") != null) {
                    field.putBoolean((Object)"autocomplete", sdfc.getAutoComplete());
                }
                boolean bl = fuzzyFetch = sdfc.getFuzzyFetch() == null ? view_config.getDefaultFuzzyFetch() : sdfc.getFuzzyFetch().booleanValue();
                if (fuzzyFetch || sdfc.getFuzzyFetch() != null) {
                    field.putBoolean((Object)"fuzzyfetch", fuzzyFetch);
                }
                if (sdfc.getDefaultValue() != null) {
                    field.putString((Object)"defaultvalue", session.parseString(sdfc.getDefaultValue(), model));
                }
                if ((options = field.getString((Object)"options")) != null) {
                    field.putString((Object)"options", TextParser.parse((String)options, (CompositeMap)model));
                }
                if (field.getString((Object)"fetchremote") != null) {
                    field.putBoolean((Object)"fetchremote", sdfc.getFetchRemote());
                }
                if (field.getString((Object)"fetchsingle") != null) {
                    field.putBoolean((Object)"fetchsingle", sdfc.getFetchSingle());
                }
                if ((lovService = field.getString((Object)"lovservice")) != null && lovService.length() > 0) {
                    String baseModel = TextParser.parse((String)lovService, (CompositeMap)model);
                    field.putString((Object)"lovservice", baseModel);
                    this.initLovService(baseModel, session, field);
                }
                if ((lovModel = field.getString((Object)"lovmodel")) != null) {
                    String baseModel = TextParser.parse((String)lovModel, (CompositeMap)model);
                    field.putString((Object)"lovmodel", baseModel);
                    this.initLovService(baseModel, session, field);
                }
                if ((lovUrl = field.getString((Object)"lovurl")) != null) {
                    field.putString((Object)"lovurl", TextParser.parse((String)lovUrl, (CompositeMap)model));
                }
                if ((lovTitle = field.getString((Object)"title")) != null) {
                    field.putString((Object)"title", session.getLocalizedPrompt(lovTitle));
                }
                if ((requiredMessage = field.getString((Object)"requiredmessage")) != null) {
                    field.putString((Object)"requiredmessage", session.parseString(requiredMessage, model));
                }
                boolean addReturn = (returnField = sdfc.getReturnField()) != null;
                field.remove((Object)"databasetype");
                String datatype = field.getString((Object)"datatype");
                if ("java.lang.String".equals(datatype)) {
                    field.remove((Object)"datatype");
                }
                JSONObject json = new JSONObject((Map)field);
                CompositeMap mapping = sdfc.getMapping();
                ArrayList<JSONObject> maplist = new ArrayList<JSONObject>();
                if (mapping != null) {
                    Iterator mit = mapping.getChildIterator();
                    while (mit.hasNext()) {
                        CompositeMap mapfield = (CompositeMap)mit.next();
                        if (returnField != null && returnField.equals(mapfield.getString((Object)"to"))) {
                            addReturn = false;
                        }
                        JSONObject mj = new JSONObject((Map)mapfield);
                        maplist.add(mj);
                    }
                }
                if (addReturn) {
                    CompositeMap returnmap = new CompositeMap("map");
                    returnmap.putString((Object)"from", sdfc.getValueField());
                    returnmap.putString((Object)"to", returnField);
                    JSONObject jo = new JSONObject((Map)returnmap);
                    maplist.add(jo);
                }
                if (maplist.size() > 0) {
                    try {
                        json.put("mapping", maplist);
                    }
                    catch (JSONException e) {
                        throw new IOException(e);
                    }
                }
                fieldList.put((Object)json);
            }
        }
        StringBuffer sb = new StringBuffer();
        String attachTab = dsc.getValidListener();
        if (attachTab != null) {
            String[] ts = attachTab.split(",");
            int i = 0;
            while (i < ts.length) {
                String tid = ts[i];
                sb.append("$('" + map.get("id") + "').on('valid',function(ds, record, name, valid){if(!valid && !Ext.get('" + tid + "').hasActiveFx()) Ext.get('" + tid + "').frame('ff0000', 3, { duration: 1 })});\n");
                ++i;
            }
        }
        map.put(VALID_SCRIPT, sb.toString());
        CompositeMap datas = dsc.getDatas();
        JSONArray dataList = new JSONArray();
        List list = null;
        HashSet dataHead = new HashSet();
        if (datas != null) {
            String ds = datas.getString((Object)"datasource", "");
            if (ds.equals("")) {
                list = datas.getChilds();
                for (CompositeMap item : list) {
                    Iterator it2 = item.keySet().iterator();
                    dataHead.addAll(item.keySet());
                    while (it2.hasNext()) {
                        String key = (String)it2.next();
                        Object valueKey = item.get((Object)key);
                        if (valueKey == null) continue;
                        String value = TextParser.parse((String)valueKey.toString(), (CompositeMap)model);
                        if (value.equals(valueKey.toString())) {
                            item.put((Object)key, valueKey);
                            continue;
                        }
                        item.put((Object)key, (Object)value);
                    }
                }
            } else {
                CompositeMap data = (CompositeMap)model.getObject(ds);
                if (data != null) {
                    list = data.getChilds();
                }
            }
        }
        if ((lcode = dsc.getLookupCode()) != null && (provider = this.lookupProvider) != null) {
            list = new ArrayList();
            try {
                list = provider.getLookupList(session.getLanguage(), lcode);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (list != null && !list.isEmpty()) {
            Iterator lit = list.iterator();
            while (lit.hasNext()) {
                dataHead.addAll(((CompositeMap)lit.next()).keySet());
            }
            this.addConfig("datahead", new JSONArray(dataHead));
            for (CompositeMap item : list) {
                JSONArray json = new JSONArray();
                Iterator it3 = dataHead.iterator();
                while (it3.hasNext()) {
                    json.put(item.get(it3.next()));
                }
                dataList.put((Object)json);
            }
        }
        if (fieldList.length() != 0) {
            this.addConfig("fields", fieldList);
        }
        if (dataList.length() != 0) {
            this.addConfig("datas", dataList);
        }
        if (!"".equals(dsc.getQueryDataSet())) {
            String queryDataset = TextParser.parse((String)dsc.getQueryDataSet(), (CompositeMap)model);
            this.addConfig("querydataset", queryDataset);
        }
        if (!"".equals(dsc.getQueryUrl(model))) {
            String queryUrl = TextParser.parse((String)dsc.getQueryUrl(), (CompositeMap)model);
            this.addConfig("queryurl", queryUrl);
        }
        if (!"".equals(dsc.getSubmitUrl())) {
            String submitUrl = TextParser.parse((String)dsc.getSubmitUrl(), (CompositeMap)model);
            this.addConfig("submiturl", submitUrl);
        }
        if (!"".equals(dsc.getBindTarget())) {
            this.addConfig("bindtarget", TextParser.parse((String)dsc.getBindTarget(), (CompositeMap)model));
        }
        if (!"".equals(dsc.getBindName())) {
            this.addConfig("bindname", TextParser.parse((String)dsc.getBindName(), (CompositeMap)model));
        }
        if (dsc.isFetchAll(model)) {
            this.addConfig("fetchall", new Boolean(dsc.isFetchAll(model)));
        }
        String autoQuery = dsc.getString("autoquery", "false");
        Boolean isAutoQuery = Boolean.FALSE;
        if (!"false".equals(autoQuery) && "true".equalsIgnoreCase(autoQuery = TextParser.parse((String)autoQuery, (CompositeMap)model))) {
            isAutoQuery = Boolean.TRUE;
        }
        if (isAutoQuery.booleanValue()) {
            this.addConfig("autoquery", isAutoQuery);
        }
        if (dsc.isAutoPageSize(model)) {
            this.addConfig("autopagesize", new Boolean(dsc.isAutoPageSize(model)));
        }
        this.addConfig("pageid", session.getSessionContext().getString((Object)"pageid", ""));
        this.addConfig("totalcountfield", dsc.getTotalCountField());
        this.addConfig("modifiedcheck", dsc.isModifiedCheck(mDefaultModifiedCheck));
        BusinessModel bm = null;
        Integer mps = null;
        String md = dsc.getModel();
        if (md != null) {
            bm = this.mFactory.getModelForRead(TextParser.parse((String)md, (CompositeMap)model));
        }
        if (bm != null) {
            mps = bm.getMaxPageSize();
        }
        if (mps != null) {
            this.addConfig("maxpagesize", new Integer(mps));
        } else {
            this.addConfig("maxpagesize", new Integer(dsc.getMaxPageSize()));
        }
        int page_size = mDefaultPageSize < 0 ? dsc.getPageSize(model) : mDefaultPageSize;
        this.addConfig("pagesize", new Integer(page_size));
        Boolean isAutoCount = dsc.isAutoCount() != null ? dsc.isAutoCount() : autoCount;
        this.addConfig("autocount", isAutoCount);
        if (dsc.getSortType() != null) {
            this.addConfig("sorttype", dsc.getSortType());
        }
        if (dsc.getNotification() != null) {
            this.addConfig("notification", dsc.getNotification());
        }
        if (dsc.isAutoCreate()) {
            this.addConfig("autocreate", new Boolean(dsc.isAutoCreate()));
        }
        if (dsc.isSelectable()) {
            this.addConfig("selectable", new Boolean(dsc.isSelectable()));
        }
        if (dsc.getSelectFunction() != null) {
            this.addConfig("selectfunction", dsc.getSelectFunction());
        }
        if (!"multiple".equals(dsc.getSelectionModel())) {
            this.addConfig("selectionmodel", dsc.getSelectionModel());
        }
        if (!"".equals(pf = TextParser.parse((String)dsc.getProcessFunction(), (CompositeMap)model))) {
            this.addConfig("processfunction", pf);
        }
        map.put("config", this.getConfigString());
    }
}

