/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.PortalConfig;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;

public class Portal
extends Component {
    private static final String DEFAULT_CLASS = "layout-portal";
    private static final String REF = "ref";
    private static final String CLOSEABLE = "closeable";
    private int cellSpacing;
    private int blockHeight;
    private int blockWidth;

    public Portal(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "portal/Portal-min.css");
        this.addJavaScript(session, context, "portal/Portal-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        PortalConfig pc = PortalConfig.getInstance(view);
        this.cellSpacing = pc.getCellSpacing();
        this.blockHeight = pc.getBlockHeight();
        this.blockWidth = pc.getBlockWidth();
        this.addConfig("movable", pc.isMovable(model));
        map.put("cellspacing", this.cellSpacing);
        map.put("portals", this.createPortals(session, context));
        map.put("config", this.getConfigString());
    }

    private String createPortals(BuildSession session, ViewContext context) throws IOException {
        List childs;
        CompositeMap view = context.getView();
        PortalConfig pc = PortalConfig.getInstance(view);
        Map map = context.getMap();
        CompositeMap portals = pc.getPortals();
        StringBuffer sb = new StringBuffer();
        sb.append("<div style='padding:0 0 " + this.cellSpacing + "px " + this.cellSpacing + "px;display:table;table-layout:fixed;width:" + ((Integer)map.get("width") - this.cellSpacing) + "px'>");
        JSONArray jsons = new JSONArray();
        if (portals != null && (childs = portals.getChilds()) != null) {
            for (CompositeMap portal : childs) {
                sb.append(this.createPortal(session, context, portal));
                jsons.put((Object)new JSONObject((Map)portal));
            }
        }
        this.addConfig("items", jsons);
        sb.append("<div class='portal-proxy' style='width:" + (this.blockWidth - 8) + "px;height:" + (this.blockHeight - 8) + "px;margin:" + this.cellSpacing + "px " + this.cellSpacing + "px 0 0;display:none'></div>");
        sb.append("</div>");
        return sb.toString();
    }

    private StringBuffer createPortal(BuildSession session, ViewContext context, CompositeMap portal) throws IOException {
        CompositeMap model = context.getModel();
        StringBuffer sb = new StringBuffer();
        String prompt = TextParser.parse((String)session.getLocalizedPrompt(portal.getString((Object)"prompt")), (CompositeMap)model);
        boolean closeable = false;
        String closeableStr = portal.getString((Object)CLOSEABLE);
        if (closeableStr != null) {
            closeable = Boolean.valueOf(TextParser.parse((String)closeableStr, (CompositeMap)model));
            portal.put((Object)CLOSEABLE, (Object)closeable);
        }
        sb.append("<table class='portal-item-wrap' style='width:" + this.blockWidth + "px;height:" + this.blockHeight + "px;margin:" + this.cellSpacing + "px " + this.cellSpacing + "px 0 0;outline:none' cellSpacing='0' cellPadding='0' hideFocus tabIndex='-1' border='0'>");
        sb.append("<thead>");
        sb.append("<tr style='height:23px;' >");
        sb.append("<td class='portal-item-caption'>");
        sb.append("<table style='height:23px;' cellspacing='0' class='portal-item-cap' unselectable='on'  onselectstart='return false;' cellpadding='0' width='100%' border='0' unselectable='on'>");
        sb.append("<tr>");
        sb.append("<td unselectable='on' class='portal-item-caption-label' width='99%'>");
        sb.append("<div unselectable='on' unselectable='on'>");
        if (prompt != null) {
            sb.append(prompt);
        }
        sb.append("</div>");
        sb.append("</td>");
        if (closeable) {
            sb.append("<td unselectable='on' class='portal-item-caption-button' nowrap>");
            sb.append("<div class='portal-item-close' unselectable='on'></div>");
            sb.append("</td>");
            sb.append("<td><div style='width:5px;'/></td>");
        }
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</thead>");
        sb.append("<tbody>");
        sb.append("<tr style='height:" + (this.blockHeight - 26) + "px'>");
        sb.append("<td class='portal-item-body' valign='top' unselectable='on'>");
        sb.append("<div class='portal-item-content' style='height:" + (this.blockHeight - 26) + "px'>");
        String ref = portal.getString((Object)REF, "");
        if ("".equals(ref)) {
            sb.append("<script>(function(){var a = window.__host = Ext.get(Ext.fly('" + this.id + "').select('.portal-item-content:last').elements[0]);if(!a.cmps)a.cmps={};})()</script>");
            List portalChilds = portal.getChilds();
            if (portalChilds != null) {
                for (CompositeMap portalChild : portalChilds) {
                    try {
                        sb.append(session.buildViewAsString(model, portalChild));
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                }
            } else if (portal.getText() != null && !"".equals(portal.getText())) {
                sb.append(portal.getText());
            }
            sb.append("<script>window.__host = null</script>");
        }
        portal.putString((Object)REF, TextParser.parse((String)ref, (CompositeMap)model));
        sb.append("</div>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</tbody>");
        sb.append("</table>");
        return sb;
    }
}

