/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.IViewBuilder;
import aurora.presentation.ViewContext;
import aurora.presentation.ViewCreationException;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.ScreenTopToolbarConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

public class ScreenTopToolbar
extends Component
implements IViewBuilder {
    public static final String VERSION = "$Revision: 7848 $";

    public ScreenTopToolbar(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected int getDefaultHeight() {
        return 44;
    }

    @Override
    public void buildView(BuildSession session, ViewContext view_context) throws IOException, ViewCreationException {
        CompositeMap view = view_context.getView();
        CompositeMap model = view_context.getModel();
        Map map = view_context.getMap();
        try {
            Writer out = session.getWriter();
            StringBuffer sb = new StringBuffer();
            Integer height = this.getComponentHeight(model, view, map);
            ScreenTopToolbarConfig sttc = ScreenTopToolbarConfig.getInstance(view);
            sb.append("<div class='screenTopToolbar' ");
            sb.append("style='padding-left:4px;height:").append(height).append("px;");
            sb.append(sttc.getStyle(""));
            sb.append("'>");
            if (view != null && view.getChilds() != null) {
                Iterator it = view.getChildIterator();
                while (it.hasNext()) {
                    CompositeMap cmp = (CompositeMap)it.next();
                    String cs = cmp.getString((Object)"style", "margin-left:5px;");
                    if (this.isButton(cmp.getNamespaceURI(), cmp.getName())) {
                        String marginTop = "3px;";
                        if ("toolbarButton".equalsIgnoreCase(cmp.getName()) || "gridButton".equalsIgnoreCase(cmp.getName())) {
                            marginTop = "15px;";
                        }
                        cs = "float:left;margin-right:1px;margin-top:" + marginTop + cs;
                    } else {
                        cs = "http://www.aurora-framework.org/application".equals(cmp.getNamespaceURI()) && cmp.getName().equalsIgnoreCase("separator") ? "height:" + (height - 4) + "px;margin-top:2px;float:left;margin-right:1px;" + cs : ("http://www.aurora-framework.org/application".equals(cmp.getNamespaceURI()) ? "float:left;margin-right:1px;margin-top:2px;line-height:" + height + "px;" + cs : "float:left;margin-right:1px;" + cs);
                    }
                    cmp.put((Object)"style", (Object)cs);
                    sb.append(session.buildViewAsString(model, cmp));
                }
            }
            sb.append("</div>");
            out.write(sb.toString());
            out.flush();
        }
        catch (Exception e) {
            throw new ViewCreationException(e);
        }
    }

    public boolean isButton(String nameSpace, String name) {
        boolean isBtn = false;
        if ("http://www.aurora-framework.org/application".equals(nameSpace)) {
            isBtn = "button".equalsIgnoreCase(name) || "toolbarButton".equalsIgnoreCase(name) || "gridButton".equalsIgnoreCase(name);
        }
        return isBtn;
    }

    @Override
    public String[] getBuildSteps(ViewContext context) {
        return null;
    }
}

