/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.config.DataSetConfig;
import aurora.presentation.component.std.config.TableColumnConfig;
import aurora.presentation.component.std.config.TableConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.CompositeUtil;
import uncertain.ocm.IObjectRegistry;

public class Table
extends Component {
    public static final String VERSION = "$Revision: 7797 $";
    private static final String ROW_SPAN = "rowspan";
    private static final String COL_SPAN = "colspan";
    private static final String DEFAULT_CLASS = "item-table";
    private static final String HEADS = "heads";
    private static final String FOOTS = "foots";
    private static final String COLUMN_TYPE = "type";
    private static final String TYPE_ROW_CHECKBOX = "rowcheck";
    private static final String TYPE_ROW_RADIO = "rowradio";

    public Table(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    protected int getDefaultWidth() {
        return -1;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "table/Table-min.css");
        this.addJavaScript(session, context, "table/Table-min.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        CompositeMap map = context.getContextMap();
        CompositeMap view = context.getView();
        TableConfig tc = TableConfig.getInstance(view);
        String rowRenderer = tc.getRowRenderer();
        String percentWidth = tc.getPercentWidth();
        String width = tc.getWidthStr();
        if (rowRenderer != null) {
            this.addConfig("rowrenderer", rowRenderer);
        }
        if (width != null) {
            map.put("percentwidth", String.valueOf(width) + "px");
        } else if (percentWidth != null) {
            map.put("percentwidth", String.valueOf(percentWidth) + "%");
        }
        ArrayList cols = new ArrayList();
        this.createHeads((Map)map, view, session, cols);
        this.generateColumns((Map)map, cols, this.hasFooterBar(tc.getColumns()));
        this.createGridEditors(session, context);
        this.createNavgationToolBar(session, context);
        String title = session.getLocalizedPrompt(tc.getTitle());
        if (title != null && !"".equals(title)) {
            title = "<TR><TD class='table_title' colspan='" + cols.size() + "'>" + title + "</TD></TR>";
            map.put("title", title);
        }
        if (!tc.isAutoAppend()) {
            this.addConfig("autoappend", new Boolean(tc.isAutoAppend()));
        }
        this.addConfig("canwheel", new Boolean(tc.isCanWheel()));
        map.put("config", this.getConfigString());
        map.put("tabindex", new Integer(tc.getTabIndex()));
    }

    private void processSelectable(Map map, CompositeMap view, CompositeMap cols, String bindTarget) {
        Boolean selectable = new Boolean(false);
        String selectionmodel = "multiple";
        CompositeMap root = view.getRoot();
        List list = CompositeUtil.findChilds((CompositeMap)root, (String)"dataSet");
        if (list != null) {
            for (CompositeMap ds : list) {
                DataSetConfig dsc = DataSetConfig.getInstance(ds);
                String id = dsc.getId("");
                if ("".equals(id)) {
                    id = IDGenerator.getInstance().generate();
                }
                if (!id.equals(bindTarget)) continue;
                selectable = new Boolean(dsc.isSelectable());
                selectionmodel = dsc.getSelectionModel();
                break;
            }
        }
        map.put("selectable", selectable);
        map.put("selectionmodel", selectionmodel);
        this.addConfig("selectable", selectable);
        this.addConfig("selectionmodel", selectionmodel);
        if (selectable.booleanValue()) {
            CompositeMap column = new CompositeMap("column");
            column.setNameSpaceURI("http://www.aurora-framework.org/application");
            column.putInt((Object)"width", 25);
            if ("multiple".equals(selectionmodel)) {
                column.putString((Object)COLUMN_TYPE, TYPE_ROW_CHECKBOX);
            } else {
                column.putString((Object)COLUMN_TYPE, TYPE_ROW_RADIO);
            }
            cols.addChild(0, column);
        }
    }

    private void createGridEditors(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        CompositeMap editors = view.getChild("editors");
        StringBuffer sb = new StringBuffer();
        if (editors != null && editors.getChilds() != null) {
            Iterator it = editors.getChildIterator();
            while (it.hasNext()) {
                CompositeMap editor = (CompositeMap)it.next();
                editor.put((Object)"tabindex", (Object)new Integer(-1));
                editor.put((Object)"style", (Object)"position:absolute;left:-1000px;top:-1000px;");
                try {
                    sb.append(session.buildViewAsString(model, editor));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
        map.put("editors", sb.toString());
    }

    private void createHeads(Map map, CompositeMap view, BuildSession session, List cols) {
        CompositeMap columns = view.getChild("columns");
        TableConfig tc = TableConfig.getInstance(view);
        String bindTarget = tc.getBindTarget();
        map.put("bindtarget", bindTarget);
        if (columns == null) {
            return;
        }
        this.processSelectable(map, view, columns, bindTarget);
        List children = columns.getChilds();
        if (children == null || children.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        HashMap<String, Integer> pro = new HashMap<String, Integer>();
        pro.put(ROW_SPAN, new Integer(1));
        this.processColumns(null, children, cols, pro);
        Integer rows = (Integer)pro.get(ROW_SPAN);
        List ukFirstList = (List)pro.get("l1");
        if (ukFirstList != null) {
            for (CompositeMap column : ukFirstList) {
                column.put((Object)ROW_SPAN, (Object)rows);
                this.addRowSpan(column);
            }
        }
        boolean showHead = tc.isShowHead();
        int i = 1;
        while (i <= rows) {
            List list = (List)pro.get("l" + i);
            if (list != null) {
                sb.append("<TR height='");
                sb.append(showHead ? "25" : "0");
                sb.append("'>");
                Iterator cit = list.iterator();
                if (cit != null) {
                    while (cit.hasNext()) {
                        sb.append(this.createColumn((CompositeMap)cit.next(), session, bindTarget, showHead));
                    }
                }
                sb.append("</TR>");
            }
            ++i;
        }
        map.put(HEADS, sb.toString());
    }

    private void generateColumns(Map map, List cols, boolean hasFoot) {
        StringBuffer sb = new StringBuffer();
        JSONArray jsons = new JSONArray();
        Iterator it = cols.iterator();
        sb.append("<TFOOT><TR class='table-foot'>");
        while (it.hasNext()) {
            CompositeMap column = (CompositeMap)it.next();
            if (column.getChilds() != null) continue;
            TableColumnConfig tcc = TableColumnConfig.getInstance(column);
            JSONObject json = new JSONObject((Map)column);
            jsons.put((Object)json);
            sb.append("<TD dataindex='");
            sb.append(tcc.getName());
            sb.append("' align='");
            sb.append(tcc.getAlign());
            sb.append("'");
            if (tcc.isHidden()) {
                sb.append(" style='display:none'");
            }
            sb.append(">&#160;</TD>");
        }
        sb.append("</TR></TFOOT>");
        if (hasFoot) {
            map.put(FOOTS, sb.toString());
        }
        this.addConfig("columns", jsons);
    }

    private void processColumns(CompositeMap parent, List children, List cols, Map pro) {
        for (CompositeMap column : children) {
            int rows;
            int level = parent == null ? 1 : parent.getInt((Object)"_level") + 1;
            if (level > (rows = ((Integer)pro.get(ROW_SPAN)).intValue())) {
                pro.put(ROW_SPAN, new Integer(level));
            }
            column.put((Object)"_level", (Object)new Integer(level));
            column.put((Object)"_parent", (Object)parent);
            ArrayList<CompositeMap> hlist = (ArrayList<CompositeMap>)pro.get("l" + level);
            if (hlist == null) {
                hlist = new ArrayList<CompositeMap>();
                pro.put("l" + level, hlist);
            }
            hlist.add(column);
            cols.add(column);
            if (column.getChilds() != null && column.getChilds().size() > 0) {
                this.processColumns(column, column.getChilds(), cols, pro);
                continue;
            }
            this.addColSpan(column);
        }
    }

    private void minusRowSpan(CompositeMap column) {
        CompositeMap parent;
        if (column == null) {
            return;
        }
        Integer rowspan = column.getInt((Object)ROW_SPAN);
        if (rowspan != null) {
            int cs = rowspan - 1;
            column.put((Object)ROW_SPAN, (Object)new Integer(cs));
        }
        if ((parent = (CompositeMap)column.get((Object)"_parent")) != null) {
            this.minusRowSpan(parent);
        }
    }

    private void addRowSpan(CompositeMap column) {
        List children = column.getChilds();
        Integer psp = column.getInt((Object)ROW_SPAN);
        if (children != null && children.size() > 0) {
            this.minusRowSpan(column);
            for (CompositeMap child : children) {
                child.put((Object)ROW_SPAN, (Object)new Integer(psp - 1));
                this.addRowSpan(child);
            }
        }
    }

    private void addColSpan(CompositeMap column) {
        if (column == null) {
            return;
        }
        CompositeMap parent = (CompositeMap)column.get((Object)"_parent");
        if (parent != null) {
            Integer colspan = parent.getInt((Object)COL_SPAN);
            parent.put((Object)COL_SPAN, (Object)new Integer(colspan == null ? 1 : colspan + 1));
        }
        this.addColSpan(parent);
    }

    private String createColumn(CompositeMap column, BuildSession session, String dataset, boolean showHead) {
        StringBuffer sb = new StringBuffer();
        TableColumnConfig tcc = TableColumnConfig.getInstance(column);
        String ct = column.getString((Object)COLUMN_TYPE);
        String pw = "";
        if (tcc.getPercentWidth() != null) {
            pw = String.valueOf(tcc.getPercentWidth()) + "%";
        }
        if (column.getString((Object)"width") != null) {
            pw = String.valueOf(column.getString((Object)"width")) + "px";
        }
        sb.append("<TD");
        if (showHead) {
            sb.append(" class='table-hc'");
        }
        if (TYPE_ROW_CHECKBOX.equals(ct)) {
            sb.append(" atype='table.rowcheck' style='width:25px;' rowspan='");
            sb.append(column.getInt((Object)ROW_SPAN));
            sb.append("'><center><div atype='table.headcheck' class='table-ckb item-ckb-u'></div></center>");
        } else if (TYPE_ROW_RADIO.equals(ct)) {
            sb.append(" atype='table.rowradio' style='width:25px;' rowspan='");
            sb.append(column.getInt((Object)ROW_SPAN));
            sb.append("'><div style='width:13px'>&nbsp;</div>");
        } else {
            sb.append(" dataindex='");
            sb.append(tcc.getName());
            sb.append("' colspan='");
            sb.append(column.getInt((Object)COL_SPAN, 1));
            sb.append("' rowspan='");
            sb.append(column.getInt((Object)ROW_SPAN));
            sb.append("'");
            sb.append(pw == null ? "" : " width='" + pw + "'");
            if (tcc.isHidden()) {
                sb.append(" style='display:none'");
            }
            sb.append(">");
            if (showHead) {
                String text = session.getLocalizedPrompt(this.getFieldPrompt(session, column, dataset));
                sb.append("".equals(text) ? "&#160;" : text);
            }
        }
        sb.append("</TD>");
        return sb.toString();
    }

    public boolean hasFooterBar(CompositeMap column) {
        TableColumnConfig tcc = TableColumnConfig.getInstance(column);
        String footerRenderer = tcc.getFooterRenderer();
        if (footerRenderer != null) {
            return true;
        }
        List childs = column.getChilds();
        if (childs != null) {
            for (CompositeMap col : childs) {
                if (!this.hasFooterBar(col)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean createNavgationToolBar(BuildSession session, ViewContext context) throws IOException {
        boolean hasNavBar = false;
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        TableConfig tc = TableConfig.getInstance(view);
        StringBuffer sb = new StringBuffer();
        if (tc.hasNavBar()) {
            hasNavBar = true;
            CompositeMap navbar = new CompositeMap("navBar");
            navbar.setNameSpaceURI("http://www.aurora-framework.org/application");
            Integer width = (Integer)map.get("width");
            navbar.put((Object)"id", (Object)(map.get("id") + "_navbar"));
            navbar.put((Object)"classname", (Object)"table-navbar");
            navbar.put((Object)"dataset", (Object)tc.getBindTarget());
            navbar.put((Object)"navbartype", (Object)view.getString((Object)"navbartype", "complex"));
            navbar.put((Object)"maxpagecount", (Object)new Integer(view.getInt((Object)"maxpagecount", 10)));
            navbar.put((Object)"enablepagesize", (Object)new Boolean(view.getBoolean((Object)"enablepagesize", true)));
            sb.append("<caption align='bottom'>");
            try {
                sb.append(session.buildViewAsString(model, navbar));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            sb.append("</caption>");
            map.put("navbar", sb.toString());
        }
        return hasNavBar;
    }
}

