/*
 * Decompiled with CFR 0.152.
 */
package aurora.security.crypto.keygen;

import aurora.security.crypto.keygen.BytesKeyGenerator;
import java.security.SecureRandom;

final class SecureRandomBytesKeyGenerator
implements BytesKeyGenerator {
    private final SecureRandom random = new SecureRandom();
    private final int keyLength;
    private static final int DEFAULT_KEY_LENGTH = 8;

    public SecureRandomBytesKeyGenerator() {
        this(8);
    }

    public SecureRandomBytesKeyGenerator(int keyLength) {
        this.keyLength = keyLength;
    }

    @Override
    public int getKeyLength() {
        return this.keyLength;
    }

    @Override
    public byte[] generateKey() {
        byte[] bytes = new byte[this.keyLength];
        this.random.nextBytes(bytes);
        return bytes;
    }
}

