/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.exception;

import aurora.database.DBUtil;
import aurora.service.ServiceThreadLocal;
import aurora.service.exception.IgnoredType;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.sql.DataSource;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.IGlobalInstance;
import uncertain.core.UncertainEngine;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.IExceptionListener;
import uncertain.exception.IExceptionWithContext;
import uncertain.ocm.IConfigurable;
import uncertain.util.resource.ILocatable;

public class ExceptionDatabaseLog
implements IExceptionListener,
IGlobalInstance,
IConfigurable {
    private IgnoredType[] ignoredTypes;
    private UncertainEngine mUncertainEngine;
    private String sql;
    private CompositeMap sqlNode;
    public static final String INSERT_SQL = "insert-sql";

    public ExceptionDatabaseLog(UncertainEngine engine) {
        this.mUncertainEngine = engine;
    }

    public void addIgnoredTypes(IgnoredType[] ignoredTypes) {
        this.ignoredTypes = ignoredTypes;
    }

    public void setInsertSql(CompositeMap sqlNode) {
        this.sqlNode = sqlNode;
        this.sql = sqlNode.getText();
        if (this.sql == null || "".equals(this.sql)) {
            throw BuiltinExceptionFactory.createCDATAMissing((ILocatable)sqlNode.asLocatable(), (String)INSERT_SQL);
        }
    }

    public CompositeMap getInsertSql() {
        return this.sqlNode;
    }

    public void onException(Throwable exception) {
        block12: {
            DataSource ds;
            if (exception == null) {
                return;
            }
            if (this.ignoredTypes != null) {
                int i = 0;
                while (i < this.ignoredTypes.length) {
                    if (exception.getClass().getCanonicalName().equals(this.ignoredTypes[i].getName())) {
                        return;
                    }
                    ++i;
                }
            }
            if ((ds = (DataSource)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(DataSource.class)) == null) {
                System.err.println("Can not get DataSource instance from uncertainEngine. Please check config file.");
                return;
            }
            Connection conn = null;
            PreparedStatement ps = null;
            CompositeMap contextCM = this.getContext(exception);
            String context = null;
            if (contextCM != null) {
                this.sql = this.parseSQL(this.sql, contextCM);
                context = contextCM.toXML();
            } else {
                this.sql = this.parseSQL(this.sql, new CompositeMap());
            }
            try {
                try {
                    conn = ds.getConnection();
                    ps = conn.prepareStatement(this.sql);
                    ps.setString(1, exception.getClass().getCanonicalName());
                    ps.setString(2, exception.getMessage());
                    ps.setString(3, this.getSource());
                    ps.setString(4, context);
                    String rootStackTrace = this.getRootStackTrace(exception);
                    ps.setString(5, rootStackTrace);
                    String fullStackTrace = this.getFullStackTrace(exception);
                    ps.setString(6, fullStackTrace);
                    ps.executeUpdate();
                    ps.close();
                    conn.commit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    DBUtil.closeStatement(ps);
                    DBUtil.closeConnection(conn);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeStatement(ps);
                DBUtil.closeConnection(conn);
                throw throwable;
            }
            DBUtil.closeStatement(ps);
            DBUtil.closeConnection(conn);
        }
    }

    private String getSource() {
        if (ServiceThreadLocal.getSource() != null) {
            return ServiceThreadLocal.getSource();
        }
        return "";
    }

    private CompositeMap getContext(Throwable exception) {
        IExceptionWithContext e;
        CompositeMap context;
        if (exception instanceof IExceptionWithContext && (context = (e = (IExceptionWithContext)exception).getExceptionContext()) != null) {
            return context;
        }
        context = ServiceThreadLocal.getCurrentThreadContext();
        if (context != null) {
            return context;
        }
        return null;
    }

    private String getRootStackTrace(Throwable exception) {
        Throwable rootCause = this.getRootCause(exception);
        return this.getExceptionStackTrace(rootCause);
    }

    private String getFullStackTrace(Throwable exception) {
        return this.getExceptionStackTrace(exception);
    }

    private String getExceptionStackTrace(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pw = new PrintStream(baos);
        exception.printStackTrace(pw);
        pw.close();
        return baos.toString();
    }

    private Throwable getRootCause(Throwable exception) {
        if (exception == null) {
            return exception;
        }
        Throwable cause = exception.getCause();
        if (cause == null) {
            return exception;
        }
        return this.getRootCause(cause);
    }

    public void beginConfigure(CompositeMap config) {
        if (config == null) {
            throw new RuntimeException("ExceptionDatabaseLog conifg can not be null!");
        }
        if (config.getChild(INSERT_SQL) == null) {
            throw BuiltinExceptionFactory.createNodeMissing((ILocatable)config.asLocatable(), (String)INSERT_SQL);
        }
    }

    public String parseSQL(String sql, CompositeMap context) {
        return TextParser.parse((String)sql, (CompositeMap)context);
    }

    public void endConfigure() {
    }
}

