/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.exception;

import aurora.application.util.LanguageUtil;
import aurora.service.ServiceContext;
import aurora.service.validation.ErrorMessage;
import java.sql.SQLException;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IExceptionHandle;
import uncertain.proc.ProcedureRunner;

public class SqlErrorMessage
extends AbstractEntry
implements IExceptionHandle {
    int code;
    String message;
    String translatedCode;
    IObjectRegistry reg;

    public SqlErrorMessage(IObjectRegistry r) {
        this.reg = r;
    }

    public SqlErrorMessage() {
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getTranslatedCode() {
        return this.translatedCode;
    }

    public void setTranslatedCode(String translatedCode) {
        this.translatedCode = translatedCode;
    }

    public boolean handleException(ProcedureRunner runner, Throwable exception) {
        int c;
        if (!(exception instanceof SQLException)) {
            return false;
        }
        SQLException sex = (SQLException)exception;
        if (sex.getCause() != null && sex.getCause() instanceof SQLException) {
            sex = (SQLException)sex.getCause();
        }
        if ((c = sex.getErrorCode()) != this.code) {
            return false;
        }
        String errorCode = this.translatedCode == null ? Integer.toString(this.code) : this.translatedCode;
        String errorMsg = this.reg == null ? this.message : LanguageUtil.getTranslatedMessage(this.reg, this.message, runner.getContext());
        ServiceContext scx = ServiceContext.createServiceContext(runner.getContext());
        ErrorMessage msg = new ErrorMessage(errorCode, errorMsg, null);
        scx.setError(msg.getObjectContext());
        scx.setSuccess(true);
        scx.putBoolean("success", false);
        return true;
    }

    public void run(ProcedureRunner runner) throws Exception {
        this.handleException(runner, runner.getException());
    }
}

