/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.ws;

import aurora.service.ws.BMWSDLGenerator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.schema.Namespace;

public class WSDLUtil {
    public static final Namespace xsd = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    public static final Namespace soap = new Namespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
    public static final Namespace wsdl = new Namespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
    public static final String TARGET_NAMESPACE = "http://www.aurora-framework.org/schema";
    public static final String NODE_NAME_PREFIX = "auto";
    public static final String TARGET_PREFIX = "tns";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void createOrientNode(String soapAction, CompositeMap xmlSample, String target_prefix, CompositeMap wsdlRoot, boolean isRequest) {
        CompositeMap schema = (CompositeMap)wsdlRoot.getObject("/types/schema");
        CompositeMap elementType = WSDLUtil.createType(xmlSample);
        schema.addChild(elementType);
        String elementTypeName = elementType.getString((Object)"name");
        CompositeMap message = WSDLUtil.createMessage(elementTypeName, isRequest);
        int index = wsdlRoot.getChilds().indexOf(wsdlRoot.getChild("types"));
        wsdlRoot.addChild(index + 1, message);
    }

    public static CompositeMap createType(CompositeMap xmlSample) {
        CompositeMap elementType = null;
        boolean isComplexTypeElement = WSDLUtil.isComplexTypeElement(xmlSample);
        if (!isComplexTypeElement) {
            elementType = WSDLUtil.getXSDNode("element");
            elementType.put((Object)"type", (Object)"xsd:string");
        } else {
            elementType = WSDLUtil.getXSDNode("element");
            CompositeMap complexType = WSDLUtil.getXSDNode("complexType");
            List childList = xmlSample.getChilds();
            if (childList != null && childList.size() != 0) {
                CompositeMap sequence = WSDLUtil.getXSDNode("sequence");
                LinkedList<CompositeMap> elementTypeList = new LinkedList<CompositeMap>();
                for (CompositeMap child : childList) {
                    CompositeMap childElementType = WSDLUtil.createType(child);
                    if (elementTypeList.contains(childElementType)) continue;
                    elementTypeList.add(childElementType);
                    sequence.addChild(childElementType);
                }
                complexType.addChild(sequence);
            }
            if (!xmlSample.isEmpty()) {
                for (Map.Entry entry : xmlSample.entrySet()) {
                    CompositeMap attributeType = WSDLUtil.getXSDNode("attribute");
                    attributeType.put((Object)"name", entry.getKey());
                    attributeType.put((Object)"type", (Object)"xsd:string");
                    complexType.addChild(attributeType);
                }
            }
            elementType.addChild(complexType);
        }
        elementType.put((Object)"name", (Object)xmlSample.getName());
        return elementType.getRoot();
    }

    public static CompositeMap createMessage(String elementName, boolean isRequest) {
        CompositeMap message = WSDLUtil.getWSDLNode("message");
        message.put((Object)"name", (Object)WSDLUtil.createMessageName(isRequest, BMWSDLGenerator.WSDL_TYPES.message));
        CompositeMap part = WSDLUtil.getWSDLNode("part");
        part.put((Object)"name", (Object)WSDLUtil.createName("", isRequest, BMWSDLGenerator.WSDL_TYPES.part));
        part.put((Object)"element", (Object)("tns:" + elementName));
        message.addChild(part);
        return message;
    }

    public static String createMessageName(boolean isRequest, BMWSDLGenerator.WSDL_TYPES types) {
        return WSDLUtil.createName("", isRequest, types);
    }

    public static String createName(String elementName, boolean isRequest, BMWSDLGenerator.WSDL_TYPES types) {
        return String.valueOf(elementName) + (isRequest ? "request" : "response") + "_" + (Object)((Object)types);
    }

    public static boolean isComplexTypeElement(CompositeMap element) {
        if (element == null) {
            return false;
        }
        return !element.isEmpty() || element.getChilds() != null;
    }

    public static CompositeMap getWSDLTemplate(String location, String name_prefix, String soapAction, String TARGET_NAMESPACE) {
        Namespace tns = new Namespace(TARGET_PREFIX, TARGET_NAMESPACE);
        CompositeMap wsdlRoot = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "definitions");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(tns.getUrl(), tns.getPrefix());
        wsdlRoot.setNamespaceMapping(map);
        wsdlRoot.put((Object)"name", (Object)name_prefix);
        wsdlRoot.put((Object)"targetNamespace", (Object)TARGET_NAMESPACE);
        CompositeMap types = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "types");
        CompositeMap schema = new CompositeMap(xsd.getPrefix(), xsd.getUrl(), "schema");
        schema.put((Object)"targetNamespace", (Object)TARGET_NAMESPACE);
        schema.put((Object)"elementFormDefault", (Object)"qualified");
        types.addChild(schema);
        wsdlRoot.addChild(types);
        CompositeMap portType = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "portType");
        portType.put((Object)"name", (Object)(String.valueOf(name_prefix) + "_" + (Object)((Object)BMWSDLGenerator.WSDL_TYPES.portType)));
        CompositeMap operation = WSDLUtil.createOpertaion(soapAction);
        portType.addChild(operation);
        wsdlRoot.addChild(portType);
        CompositeMap binding = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "binding");
        String bindingName = WSDLUtil.getBindingName(location);
        binding.put((Object)"name", (Object)bindingName);
        binding.put((Object)"type", (Object)("tns:" + name_prefix + "_" + (Object)((Object)BMWSDLGenerator.WSDL_TYPES.portType)));
        CompositeMap transport = new CompositeMap(soap.getPrefix(), soap.getUrl(), "binding");
        transport.put((Object)"style", (Object)"document");
        transport.put((Object)"transport", (Object)"http://schemas.xmlsoap.org/soap/http");
        binding.addChild(transport);
        CompositeMap bindingOpertaion = WSDLUtil.createBindingOpertaion(soapAction);
        binding.addChild(bindingOpertaion);
        wsdlRoot.addChild(binding);
        CompositeMap service = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "service");
        service.put((Object)"name", (Object)(String.valueOf(name_prefix) + "_" + (Object)((Object)BMWSDLGenerator.WSDL_TYPES.service)));
        CompositeMap port = new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), "port");
        port.put((Object)"name", (Object)(String.valueOf(name_prefix) + "_" + (Object)((Object)BMWSDLGenerator.WSDL_TYPES.port)));
        port.put((Object)"binding", (Object)("tns:" + bindingName));
        service.addChild(port);
        CompositeMap address = new CompositeMap(soap.getPrefix(), soap.getUrl(), "address");
        address.put((Object)"location", (Object)location);
        port.addChild(address);
        wsdlRoot.addChild(service);
        return wsdlRoot;
    }

    private static String getBindingName(String location) {
        String[] parts = location.split("/");
        int length = parts.length;
        return String.valueOf(parts[length - 2]) + "." + parts[length - 1] + "_" + (Object)((Object)BMWSDLGenerator.WSDL_TYPES.binding);
    }

    public static CompositeMap createOpertaion(String soapAction) {
        CompositeMap operation = WSDLUtil.getWSDLNode("operation");
        operation.put((Object)"name", (Object)soapAction);
        CompositeMap inputElement = WSDLUtil.getWSDLNode("input");
        inputElement.put((Object)"message", (Object)("tns:" + WSDLUtil.createMessageName(true, BMWSDLGenerator.WSDL_TYPES.message)));
        CompositeMap outputElement = WSDLUtil.getWSDLNode("output");
        outputElement.put((Object)"message", (Object)("tns:" + WSDLUtil.createMessageName(false, BMWSDLGenerator.WSDL_TYPES.message)));
        operation.addChild(inputElement);
        operation.addChild(outputElement);
        return operation;
    }

    public static CompositeMap createBindingOpertaion(String soapAction) {
        CompositeMap oper = WSDLUtil.getWSDLNode("operation");
        CompositeMap soap = WSDLUtil.getSOAPNode("operation");
        soap.put((Object)"soapAction", (Object)soapAction);
        oper.addChild(soap);
        oper.put((Object)"name", (Object)soapAction);
        CompositeMap input = WSDLUtil.getWSDLNode("input");
        CompositeMap inputBody = WSDLUtil.getSOAPNode("body");
        inputBody.put((Object)"use", (Object)"literal");
        input.addChild(inputBody);
        oper.addChild(input);
        CompositeMap output = WSDLUtil.getWSDLNode("output");
        CompositeMap outputBody = WSDLUtil.getSOAPNode("body");
        outputBody.put((Object)"use", (Object)"literal");
        output.addChild(outputBody);
        oper.addChild(output);
        return oper;
    }

    public static CompositeMap getXSDNode(String name) {
        return new CompositeMap(xsd.getPrefix(), xsd.getUrl(), name);
    }

    public static CompositeMap getWSDLNode(String name) {
        return new CompositeMap(wsdl.getPrefix(), wsdl.getUrl(), name);
    }

    public static CompositeMap getSOAPNode(String name) {
        return new CompositeMap(soap.getPrefix(), soap.getUrl(), name);
    }
}

