/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.jndi.intercept.spi;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.ow2.carol.jndi.intercept.ContextInterceptor;
import org.ow2.carol.jndi.intercept.InterceptorManager;
import org.ow2.carol.jndi.intercept.operation.AddToEnvironmentInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.CloseInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.GetEnvironmentInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.GetNameInNamespaceInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameBindInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameComposeNameInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameCreateSubcontextInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameDestroySubcontextInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameGetNameParserInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameListBindingsInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameListInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameLookupInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameLookupLinkInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameRebindInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameRenameInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.NameUnbindInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.RemoveFromEnvironmentInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringBindInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringComposeNameInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringCreateSubcontextInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringDestroySubcontextInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringGetNameParserInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringListBindingsInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringListInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringLookupInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringLookupLinkInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringRebindInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringRenameInterceptionContext;
import org.ow2.carol.jndi.intercept.operation.StringUnbindInterceptionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptableContext
implements Context {
    private InterceptorManager manager;
    private Context wrapped;

    public InterceptableContext(InterceptorManager manager, Context wrapped) {
        this.manager = manager;
        this.wrapped = wrapped;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        try {
            NameLookupInterceptionContext lc = new NameLookupInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name});
            return lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform lookup", e);
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        try {
            StringLookupInterceptionContext lc = new StringLookupInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name});
            return lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform lookup", e);
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        try {
            NameBindInterceptionContext intercepted = new NameBindInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name, obj});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform bind", e);
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        try {
            StringBindInterceptionContext intercepted = new StringBindInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name, obj});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform bind", e);
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        try {
            NameRebindInterceptionContext intercepted = new NameRebindInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name, obj});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform rebind", e);
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        try {
            StringRebindInterceptionContext intercepted = new StringRebindInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name, obj});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform rebind", e);
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        try {
            NameUnbindInterceptionContext intercepted = new NameUnbindInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform unbind", e);
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        try {
            StringUnbindInterceptionContext intercepted = new StringUnbindInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform unbind", e);
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        try {
            NameRenameInterceptionContext intercepted = new NameRenameInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{oldName, newName});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform rename", e);
        }
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        try {
            StringRenameInterceptionContext intercepted = new StringRenameInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{oldName, newName});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform rename", e);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        try {
            NameListInterceptionContext intercepted = new NameListInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            return (NamingEnumeration)intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform list", e);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        try {
            StringListInterceptionContext intercepted = new StringListInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            return (NamingEnumeration)intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform list", e);
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        try {
            NameListBindingsInterceptionContext intercepted = new NameListBindingsInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            return (NamingEnumeration)intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform listBindings", e);
        }
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        try {
            StringListBindingsInterceptionContext intercepted = new StringListBindingsInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            return (NamingEnumeration)intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform listBindings", e);
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        try {
            NameDestroySubcontextInterceptionContext intercepted = new NameDestroySubcontextInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform destroySubcontext", e);
        }
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        try {
            StringDestroySubcontextInterceptionContext intercepted = new StringDestroySubcontextInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform destroySubcontext", e);
        }
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        try {
            NameCreateSubcontextInterceptionContext intercepted = new NameCreateSubcontextInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            return (Context)intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform createSubcontext", e);
        }
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        try {
            StringCreateSubcontextInterceptionContext intercepted = new StringCreateSubcontextInterceptionContext(this.wrapped);
            intercepted.setInterceptors(this.getInterceptors().iterator());
            intercepted.setParameters(new Object[]{name});
            return (Context)intercepted.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform createSubcontext", e);
        }
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        try {
            NameLookupLinkInterceptionContext lc = new NameLookupLinkInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name});
            return lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform lookupLink", e);
        }
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        try {
            StringLookupLinkInterceptionContext lc = new StringLookupLinkInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name});
            return lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform lookupLink", e);
        }
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        try {
            NameGetNameParserInterceptionContext lc = new NameGetNameParserInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name});
            return (NameParser)lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform getNameParser", e);
        }
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        try {
            StringGetNameParserInterceptionContext lc = new StringGetNameParserInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name});
            return (NameParser)lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform getNameParser", e);
        }
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        try {
            NameComposeNameInterceptionContext lc = new NameComposeNameInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name, prefix});
            return (Name)lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform composeName", e);
        }
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        try {
            StringComposeNameInterceptionContext lc = new StringComposeNameInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{name, prefix});
            return (String)lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform composeName", e);
        }
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        try {
            AddToEnvironmentInterceptionContext lc = new AddToEnvironmentInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{propName, propVal});
            return lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform addToEnvironment", e);
        }
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        try {
            RemoveFromEnvironmentInterceptionContext lc = new RemoveFromEnvironmentInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.setParameters(new Object[]{propName});
            return lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform removeFromEnvironment", e);
        }
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        try {
            GetEnvironmentInterceptionContext lc = new GetEnvironmentInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            return (Hashtable)lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform getEnvironment", e);
        }
    }

    @Override
    public void close() throws NamingException {
        try {
            CloseInterceptionContext lc = new CloseInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform close", e);
        }
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        try {
            GetNameInNamespaceInterceptionContext lc = new GetNameInNamespaceInterceptionContext(this.wrapped);
            lc.setInterceptors(this.getInterceptors().iterator());
            return (String)lc.proceed();
        }
        catch (Exception e) {
            throw InterceptableContext.namingException("Cannot perform getNameInNamespace", e);
        }
    }

    private Iterable<ContextInterceptor> getInterceptors() {
        return this.manager.getInterceptors();
    }

    private static NamingException namingException(String message, Exception cause) {
        NamingException ne = new NamingException(message);
        return (NamingException)ne.initCause(cause);
    }
}

