/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.util.List;
import org.ow2.carol.rmi.interceptor.spi.JClientRequestInterceptor;
import org.ow2.carol.rmi.interceptor.spi.JServerRequestInterceptor;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorHelper;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsGroup;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JInterceptorsKind;
import org.ow2.carol.rmi.jrmp.interceptor.impl.JServerInterceptorHelper;
import org.ow2.carol.rmi.jrmp.server.JRemoteServerCall;
import org.ow2.carol.rmi.jrmp.server.JUnicastRef;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnicastServerRef
extends UnicastServerRef {
    protected final JServerRequestInterceptor[] sis;
    protected final JClientRequestInterceptor[] cis;
    protected final String[] initializers;
    private int localId = -2;

    public JUnicastServerRef(LiveRef ref, List<JInterceptorsGroup> jinterceptorsList) {
        super(ref);
        JInterceptorsKind interceptorsByType = JInterceptorHelper.getInterceptorsByType(jinterceptorsList);
        this.sis = interceptorsByType.getJServerRequestInterceptors();
        this.cis = interceptorsByType.getJClientRequestInterceptors();
        List<String> initmp = interceptorsByType.getInitializers();
        this.initializers = initmp.toArray(new String[initmp.size()]);
    }

    public JUnicastServerRef(int port, List<JInterceptorsGroup> jinterceptorsList) {
        super(new LiveRef(port));
        JInterceptorsKind interceptorsByType = JInterceptorHelper.getInterceptorsByType(jinterceptorsList);
        this.sis = interceptorsByType.getJServerRequestInterceptors();
        this.cis = interceptorsByType.getJClientRequestInterceptors();
        List<String> initmp = interceptorsByType.getInitializers();
        this.initializers = initmp.toArray(new String[initmp.size()]);
    }

    @Override
    public String getRefClass(ObjectOutput out) {
        super.getRefClass(out);
        return "org.ow2.carol.rmi.jrmp.server.JUnicastServerRef";
    }

    @Override
    protected RemoteRef getClientRef() {
        return new JUnicastRef(this.ref, this.cis, this.initializers, this.localId);
    }

    public Remote exportObject(Remote obj, Object object, int localId) throws RemoteException {
        this.localId = localId;
        return super.exportObject(obj, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unmarshalCustomCallData(ObjectInput in) throws IOException, ClassNotFoundException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            JServerInterceptorHelper.receive_request(in, this.sis);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        super.unmarshalCustomCallData(in);
    }

    @Override
    public void dispatch(Remote obj, RemoteCall call) throws IOException {
        super.dispatch(obj, new JRemoteServerCall(call, this.sis));
    }
}

