/*
 * Decompiled with CFR 0.152.
 */
package uncertain.ocm;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.mbean.IMBeanNameProvider;
import uncertain.mbean.IMBeanRegister;
import uncertain.mbean.IMBeanRegistrable;
import uncertain.ocm.IObjectCreator;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.ISingleton;
import uncertain.ocm.mbean.ObjectRegistryImplWrapper;

public class ObjectRegistryImpl
implements IObjectCreator,
IObjectRegistry,
IMBeanRegistrable {
    public static final String LOGGING_SPACE = "uncertain.objectspace";
    Map instance_map = new HashMap();
    Map constructor_map = new HashMap();
    Map parameter_map = new HashMap();
    Map constructor_list_map;
    Map singleton_instance_map;
    Logger logger;
    ObjectRegistryImpl parent = null;

    public ObjectRegistryImpl() {
        this.constructor_list_map = new HashMap();
        this.singleton_instance_map = new HashMap();
        this.logger = Logger.getLogger(LOGGING_SPACE);
    }

    public ObjectRegistryImpl(ObjectRegistryImpl p) {
        this.setParent(p);
        this.logger = p.logger;
    }

    public ObjectRegistryImpl getParent() {
        return this.parent;
    }

    public void setParent(ObjectRegistryImpl parent) {
        this.parent = parent;
    }

    @Override
    public Object getInstanceOfType(Class type) {
        Object o = this.instance_map.get(type);
        if (o != null) {
            return o;
        }
        if (this.parent != null) {
            return this.parent.getInstanceOfType(type);
        }
        return null;
    }

    @Override
    public void registerInstanceOnce(Class type, Object instance) {
        if (instance != null && !type.isAssignableFrom(instance.getClass()) && !type.isPrimitive()) {
            throw new IllegalArgumentException("type " + type.getName() + " isn't compatible with " + instance.getClass().getName());
        }
        this.instance_map.put(type, instance);
    }

    @Override
    public void registerInstance(Class type, Object instance) {
        this.registerInstanceOnce(type, instance);
        if (type.isInterface()) {
            return;
        }
        Class cls = type.getSuperclass();
        while (cls != null && !Object.class.equals(cls)) {
            if (!this.instance_map.containsKey(cls)) {
                this.registerInstanceOnce(cls, instance);
            }
            cls = cls.getSuperclass();
        }
        Class<?>[] interfaces = type.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (!this.instance_map.containsKey(interfaces[i])) {
                this.registerInstanceOnce(interfaces[i], instance);
            }
            ++i;
        }
    }

    @Override
    public void registerInstance(Object instance) {
        this.registerInstance(instance.getClass(), instance);
    }

    ArrayList getConstructorList(Class type) {
        if (this.parent != null) {
            return this.parent.getConstructorList(type);
        }
        ArrayList cList = (ArrayList)this.constructor_list_map.get(type);
        if (cList == null) {
            Constructor<?>[] cscts = type.getConstructors();
            int length = cscts.length;
            if (length == 0) {
                throw new IllegalArgumentException("No public constructor available for " + type);
            }
            cList = new ArrayList(length);
            int i = 0;
            while (i < length) {
                cList.add(cscts[i]);
                ++i;
            }
            Collections.sort(cList, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Constructor c1 = (Constructor)o1;
                    Constructor c2 = (Constructor)o2;
                    return c1.getParameterTypes().length - c2.getParameterTypes().length;
                }

                @Override
                public boolean equals(Object obj) {
                    return obj != null && obj.getClass().equals(this.getClass());
                }
            });
            this.constructor_list_map.put(type, cList);
        }
        return cList;
    }

    Constructor getProperConstructor(Class type) {
        ArrayList cList = this.getConstructorList(type);
        int i = cList.size() - 1;
        while (i >= 0) {
            Constructor c = (Constructor)cList.get(i);
            Class<?>[] types = c.getParameterTypes();
            boolean proper = true;
            int n = 0;
            while (n < types.length) {
                if (this.getInstanceOfType(types[n]) == null) {
                    proper = false;
                }
                ++n;
            }
            if (proper) {
                return c;
            }
            --i;
        }
        return null;
    }

    public void analysisConstructor(ILogger logger, Class type) {
        ArrayList cList = this.getConstructorList(type);
        logger.log(String.valueOf(type.getName()) + " has " + cList.size() + " constructors");
        int count = 1;
        int i = cList.size() - 1;
        while (i >= 0) {
            Constructor c = (Constructor)cList.get(i);
            Class<?>[] types = c.getParameterTypes();
            logger.log("No." + count + " types:");
            int types_count = 0;
            while (types_count < types.length) {
                logger.log(types[types_count].getName());
                ++types_count;
            }
            boolean proper = true;
            int n = 0;
            while (n < types.length) {
                if (this.getInstanceOfType(types[n]) == null) {
                    proper = false;
                    logger.log("type " + types[n].getName() + " is missing, so discard");
                } else {
                    logger.log(String.valueOf(types[n].getName()) + " -> " + this.getInstanceOfType(types[n]));
                }
                ++n;
            }
            if (proper) {
                logger.log("This constructor is OK:");
                return;
            }
            --i;
            ++count;
        }
        logger.log("Can't find proper constructor");
    }

    public Constructor getConstructor(Class type) {
        Constructor c = (Constructor)this.constructor_map.get(type);
        if (c == null) {
            c = this.getProperConstructor(type);
            if (c != null) {
                Class<?>[] types = c.getParameterTypes();
                Object[] params = new Object[types.length];
                int i = 0;
                while (i < types.length) {
                    params[i] = this.getInstanceOfType(types[i]);
                    ++i;
                }
                this.constructor_map.put(type, c);
                this.parameter_map.put(type, params);
                this.logger.fine("Constructor for " + type + " set to " + c);
            } else {
                this.logger.warning("Can't get proper constructor for " + type);
            }
        }
        return c;
    }

    public boolean canCreateInstance(Class type) {
        return this.constructor_map.containsKey(type);
    }

    private Object createInstanceInternal(Class type) throws Exception {
        Constructor c = this.getConstructor(type);
        if (c == null) {
            return null;
        }
        Object[] params = (Object[])this.parameter_map.get(type);
        return c.newInstance(params);
    }

    @Override
    public Object createInstance(Class type) throws Exception {
        if (ISingleton.class.isAssignableFrom(type)) {
            Object instance = this.singleton_instance_map.get(type);
            if (instance == null) {
                instance = this.createInstanceInternal(type);
                this.singleton_instance_map.put(type, instance);
            }
            return instance;
        }
        return this.createInstanceInternal(type);
    }

    public Object createInstanceSilently(Class type) {
        try {
            return this.createInstance(type);
        }
        catch (Throwable ex) {
            if (ex.getCause() != null) {
                ex = ex.getCause();
            }
            this.logger.log(Level.SEVERE, "error occur when create instance of " + type, ex);
            return null;
        }
    }

    public Map getInstanceMapping() {
        return this.instance_map;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public CompositeMap dumpInstanceList(CompositeMap list) {
        for (Map.Entry entry : this.instance_map.entrySet()) {
            Object obj = entry.getValue();
            Class type = (Class)entry.getKey();
            CompositeMap instance = new CompositeMap("instance");
            instance.put("type", type.getName());
            instance.put("instance", obj.toString());
            instance.put("instance_type", obj.getClass().getName());
            list.addChild(instance);
        }
        return list;
    }

    @Override
    public void registerMBean(IMBeanRegister register, IMBeanNameProvider name_provider) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        new ObjectRegistryImplWrapper(this).registerMBean(register, name_provider);
    }
}

