/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import uncertain.logging.ILogger;

public class LoggingUtil {
    static Level[] level_array = new Level[20];

    static {
        LoggingUtil.putLevel(Level.SEVERE);
        LoggingUtil.putLevel(Level.WARNING);
        LoggingUtil.putLevel(Level.SEVERE);
        LoggingUtil.putLevel(Level.INFO);
        LoggingUtil.putLevel(Level.CONFIG);
        LoggingUtil.putLevel(Level.FINE);
        LoggingUtil.putLevel(Level.FINER);
        LoggingUtil.putLevel(Level.FINEST);
    }

    static void putLevel(Level l) {
        LoggingUtil.level_array[l.intValue() / 100] = l;
    }

    public static Level getLevel(int value) {
        if (value == Integer.MIN_VALUE) {
            return Level.ALL;
        }
        if (value == Integer.MAX_VALUE) {
            return Level.OFF;
        }
        Level l = level_array[value / 100];
        if (l == null) {
            throw new IllegalArgumentException("Unknown level value:" + value);
        }
        return l;
    }

    public static void setHandleLevels(Logger logger, Level l) {
        logger.setLevel(l);
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                handlers[i].setLevel(l);
                ++i;
            }
        }
    }

    public static void logException(Throwable thr, ILogger logger, Level level) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        thr.printStackTrace(new PrintStream(baos));
        String str = baos.toString();
        logger.log(level, str);
    }

    public static void logException(Throwable thr, ILogger logger) {
        LoggingUtil.logException(thr, logger, Level.SEVERE);
    }
}

