/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.docx4j.docx.sample;

import aurora.ide.meta.docx4j.docx.sample.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.table.TblFactory;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.BufferUtil;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Body;
import org.docx4j.wml.Br;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.Document;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.STBorder;
import org.docx4j.wml.STBrType;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;
import org.pptx4j.pml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyStyles {
    private static org.docx4j.wml.ObjectFactory objectFactory = new org.docx4j.wml.ObjectFactory();
    private static org.docx4j.wml.ObjectFactory factory = new org.docx4j.wml.ObjectFactory();
    private static WordprocessingMLPackage wordMLPackage;
    protected static Logger log;

    static {
        log = LoggerFactory.getLogger(WordprocessingMLPackage.class);
    }

    public static void main(String[] args) throws Exception {
        boolean save = true;
        wordMLPackage = CopyStyles.createPackage();
        MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
        Relationship relationship = CopyStyles.createHeaderPart(wordMLPackage);
        CopyStyles.createHeaderReference(wordMLPackage, relationship);
        relationship = CopyStyles.createFooterPart(wordMLPackage);
        CopyStyles.createFooterReference(wordMLPackage, relationship);
        mdp.addStyledParagraphOfText("TitleBar", "");
        mdp.addStyledParagraphOfText("Title", "");
        mdp.addStyledParagraphOfText("Title", "HAND ENTERPRISE SOLUTIONS");
        mdp.addStyledParagraphOfText("DocTitle2", "<ISP> < ISP_WACP5050>");
        mdp.addStyledParagraphOfText("DocTitle3", Messages.CopyStyles_9);
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", Messages.CopyStyles_15);
        mdp.addStyledParagraphOfText("Docinfo", Messages.CopyStyles_17);
        mdp.addStyledParagraphOfText("Docinfo", Messages.CopyStyles_19);
        mdp.addStyledParagraphOfText("Docinfo", Messages.CopyStyles_21);
        mdp.addStyledParagraphOfText("Docinfo", Messages.CopyStyles_23);
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("DocInfotabletitle", Messages.CopyStyles_27);
        int writableWidthTwips = ((SectionWrapper)wordMLPackage.getDocumentModel().getSections().get(0)).getPageDimensions().getWritableWidthTwips();
        int cols = 2;
        int cellWidthTwips = new Double(Math.floor(writableWidthTwips / cols)).intValue();
        Tbl tbl = TblFactory.createTable((int)3, (int)cols, (int)cellWidthTwips);
        String strTblPr = "<w:tblPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:tblStyle w:val=\"TableGrid\"/><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblInd w:w=\"250\" w:type=\"dxa\" /><w:tblLook w:val=\"04A0\" w:firstRow=\"1\" w:lastRow=\"0\" w:firstColumn=\"1\" w:lastColumn=\"0\" w:noHBand=\"0\" w:noVBand=\"1\" /></w:tblPr>";
        TblPr tblPr = null;
        try {
            tblPr = (TblPr)XmlUtils.unmarshalString((String)strTblPr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        tbl.setTblPr(tblPr);
        CopyStyles.createTc(tbl, 0, 0, Messages.CopyStyles_35);
        CopyStyles.createTc(tbl, 0, 1, "");
        CopyStyles.createTc(tbl, 1, 0, Messages.CopyStyles_37);
        CopyStyles.createTc(tbl, 1, 1, "");
        CopyStyles.createTc(tbl, 2, 0, Messages.CopyStyles_39);
        CopyStyles.createTc(tbl, 2, 1, "");
        mdp.addObject((Object)tbl);
        mdp.addStyledParagraphOfText("Docinfo", "");
        CopyStyles.createNewPage(mdp);
        System.out.println(XmlUtils.marshaltoString((Object)mdp.getJaxbElement(), (boolean)true, (boolean)true));
        if (save) {
            String filename = "/Users/shiliyan/Desktop/OUT_CopyStyles.docx";
            wordMLPackage.save(new File(filename));
            System.out.println("Saved " + filename);
        }
    }

    static void createTc(Tbl tbl, int row, int cols, String content) {
        Tc tc = (Tc)((Tr)tbl.getContent().get(row)).getContent().get(cols);
        tc.getContent().clear();
        tc.getContent().add(wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("DocInfoTable", content));
    }

    private static void addBorders(Tbl table) {
        table.setTblPr(new TblPr());
        CTBorder border = new CTBorder();
        border.setColor("auto");
        border.setSz(new BigInteger("4"));
        border.setSpace(new BigInteger("0"));
        border.setVal(STBorder.SINGLE);
        TblBorders borders = new TblBorders();
        borders.setBottom(border);
        borders.setLeft(border);
        borders.setRight(border);
        borders.setTop(border);
        borders.setInsideH(border);
        borders.setInsideV(border);
        table.getTblPr().setTblBorders(borders);
    }

    private static Tbl createTableWithContent() {
        Tbl table = factory.createTbl();
        Tr tableRow = factory.createTr();
        CopyStyles.addTableCell(tableRow, Messages.CopyStyles_50);
        CopyStyles.addTableCell(tableRow, "");
        table.getContent().add(tableRow);
        tableRow = factory.createTr();
        CopyStyles.addTableCell(tableRow, Messages.CopyStyles_52);
        CopyStyles.addTableCell(tableRow, "");
        table.getContent().add(tableRow);
        tableRow = factory.createTr();
        CopyStyles.addTableCell(tableRow, Messages.CopyStyles_54);
        CopyStyles.addTableCell(tableRow, "");
        table.getContent().add(tableRow);
        return table;
    }

    private static void addTableCell(Tr tableRow, String content) {
        Tc tableCell = factory.createTc();
        tableCell.getContent().add(wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("DocInfoTable", content));
        tableRow.getContent().add(tableCell);
    }

    public static P createNewPage(MainDocumentPart mdp) {
        P p = objectFactory.createP();
        R run = objectFactory.createR();
        Br br = objectFactory.createBr();
        br.setType(STBrType.PAGE);
        run.getContent().add(br);
        p.getContent().add(run);
        mdp.getContent().add(p);
        return p;
    }

    public static Relationship createFooterPart(WordprocessingMLPackage wordprocessingMLPackage) throws Exception {
        FooterPart headerPart = new FooterPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        headerPart.setJaxbElement((Object)CopyStyles.getFtr(wordprocessingMLPackage, (Part)headerPart));
        return rel;
    }

    private static Ftr getFtr(WordprocessingMLPackage wordPackage, Part sourcePart) throws Exception {
        Jc jc;
        org.docx4j.wml.ObjectFactory factory = new org.docx4j.wml.ObjectFactory();
        Ftr ftr = factory.createFtr();
        P p = factory.createP();
        Text t = factory.createText();
        t.setValue("Company Confidential - For internal use only");
        R run = factory.createR();
        run.getContent().add(t);
        p.getContent().add(run);
        PPr pPr = p.getPPr();
        if (pPr == null) {
            pPr = factory.createPPr();
        }
        if ((jc = pPr.getJc()) == null) {
            jc = new Jc();
        }
        jc.setVal(JcEnumeration.CENTER);
        pPr.setJc(jc);
        p.setPPr(pPr);
        ftr.getContent().add(p);
        return ftr;
    }

    public static void createFooterReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = objectFactory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        FooterReference headerReference = objectFactory.createFooterReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
    }

    public static Relationship createHeaderPart(WordprocessingMLPackage wordprocessingMLPackage) throws Exception {
        HeaderPart headerPart = new HeaderPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        headerPart.setJaxbElement((Object)CopyStyles.getHdr(wordprocessingMLPackage, (Part)headerPart));
        return rel;
    }

    public static void createHeaderReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = objectFactory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        HeaderReference headerReference = objectFactory.createHeaderReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
    }

    public static Hdr getHdr(WordprocessingMLPackage wordprocessingMLPackage, Part sourcePart) throws Exception {
        Hdr hdr = objectFactory.createHdr();
        File file = new File(String.valueOf(System.getProperty("user.dir")) + "/src/test/resources/images/hand-china.png");
        FileInputStream is = new FileInputStream(file);
        hdr.getContent().add(CopyStyles.newImage(wordprocessingMLPackage, sourcePart, BufferUtil.getBytesFromInputStream((InputStream)is), "hand-china", "hand-china", 1, 2));
        return hdr;
    }

    public static P newImage(WordprocessingMLPackage wordMLPackage, Part sourcePart, byte[] bytes, String filenameHint, String altText, int id1, int id2) throws Exception {
        Jc jc;
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wordMLPackage, (Part)sourcePart, (byte[])bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, 2000L, false);
        new org.docx4j.dml.ObjectFactory();
        new ObjectFactory();
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        PPr pPr = p.getPPr();
        if (pPr == null) {
            pPr = factory.createPPr();
        }
        if ((jc = pPr.getJc()) == null) {
            jc = new Jc();
        }
        jc.setVal(JcEnumeration.RIGHT);
        pPr.setJc(jc);
        p.setPPr(pPr);
        return p;
    }

    public static WordprocessingMLPackage createPackage() throws InvalidFormatException {
        String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
        log.info("Using paper size: " + papersize);
        String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
        boolean landscape = Boolean.parseBoolean(landscapeString);
        log.info("Landscape orientation: " + landscape);
        return CopyStyles.createPackage(PageSizePaper.valueOf((String)papersize), landscape);
    }

    public static WordprocessingMLPackage createPackage(PageSizePaper sz, boolean landscape) throws InvalidFormatException {
        WordprocessingMLPackage wmlPack = new WordprocessingMLPackage();
        MainDocumentPart wordDocumentPart = new MainDocumentPart();
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        Body body = factory.createBody();
        Document wmlDocumentEl = factory.createDocument();
        wmlDocumentEl.setBody(body);
        PageDimensions page = new PageDimensions();
        page.setPgSize(sz, landscape);
        SectPr sectPr = factory.createSectPr();
        body.setSectPr(sectPr);
        sectPr.setPgSz(page.getPgSz());
        sectPr.setPgMar(page.getPgMar());
        wordDocumentPart.setJaxbElement((Object)wmlDocumentEl);
        wmlPack.addTargetPart((Part)wordDocumentPart);
        StyleDefinitionsPart stylesPart = new StyleDefinitionsPart();
        try {
            CopyStyles.unmarshalDefaultStyles(stylesPart, "aurora/ide/meta/docx4j/docx/sample/styles.xml");
            wordDocumentPart.addTargetPart((Part)stylesPart);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            JaxbXmlPartXPathAware styleEffectsPart = new JaxbXmlPartXPathAware(new PartName("/word/stylesWithEffects.xml")){};
            styleEffectsPart.setContentType(new ContentType("application/vnd.ms-word.stylesWithEffects+xml"));
            styleEffectsPart.setRelationshipType("http://schemas.microsoft.com/office/2007/relationships/stylesWithEffects");
            CopyStyles.unmarshalDefaultStyles(styleEffectsPart, "aurora/ide/meta/docx4j/docx/sample/stylesWithEffects.xml");
            wordDocumentPart.addTargetPart((Part)styleEffectsPart);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        DocPropsCorePart core = new DocPropsCorePart();
        org.docx4j.docProps.core.ObjectFactory coreFactory = new org.docx4j.docProps.core.ObjectFactory();
        core.setJaxbElement((Object)coreFactory.createCoreProperties());
        wmlPack.addTargetPart((Part)core);
        DocPropsExtendedPart app = new DocPropsExtendedPart();
        org.docx4j.docProps.extended.ObjectFactory extFactory = new org.docx4j.docProps.extended.ObjectFactory();
        app.setJaxbElement((Object)extFactory.createProperties());
        wmlPack.addTargetPart((Part)app);
        return wmlPack;
    }

    public static Object unmarshalDefaultStyles(StyleDefinitionsPart stylesPart, String path) throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource((String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stylesPart.unmarshal(is);
    }

    public static Object unmarshalDefaultStyles(JaxbXmlPartXPathAware stylesPart, String path) throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource((String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stylesPart.unmarshal(is);
    }
}

