/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.docx4j.docx.sample;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.docx4j.Docx4jProperties;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.structure.PageSizePaper;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPartAbstractImage;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.BufferUtil;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;
import org.docx4j.wml.Drawing;
import org.docx4j.wml.FooterReference;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.HdrFtrRef;
import org.docx4j.wml.HeaderReference;
import org.docx4j.wml.Jc;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.R;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Text;
import org.pptx4j.pml.ObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSDDocumentPackage {
    private org.docx4j.wml.ObjectFactory objectFactory = new org.docx4j.wml.ObjectFactory();
    private WordprocessingMLPackage wordMLPackage;
    protected static Logger log = LoggerFactory.getLogger(WordprocessingMLPackage.class);

    public void create() throws Exception {
        this.wordMLPackage = this.createPackage();
        Relationship relationship = this.createHeaderPart(this.getWordMLPackage());
        this.createHeaderReference(this.getWordMLPackage(), relationship);
        relationship = this.createFooterPart(this.getWordMLPackage());
        this.createFooterReference(this.getWordMLPackage(), relationship);
    }

    protected WordprocessingMLPackage createPackage() throws InvalidFormatException {
        String papersize = Docx4jProperties.getProperties().getProperty("docx4j.PageSize", "A4");
        log.info("Using paper size: " + papersize);
        String landscapeString = Docx4jProperties.getProperties().getProperty("docx4j.PageOrientationLandscape", "false");
        boolean landscape = Boolean.parseBoolean(landscapeString);
        log.info("Landscape orientation: " + landscape);
        return this.createPackage(PageSizePaper.valueOf((String)papersize), landscape);
    }

    protected WordprocessingMLPackage createPackage(PageSizePaper sz, boolean landscape) throws InvalidFormatException {
        WordprocessingMLPackage wmlPack = new WordprocessingMLPackage();
        MainDocumentPart wordDocumentPart = new MainDocumentPart();
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        Body body = factory.createBody();
        Document wmlDocumentEl = factory.createDocument();
        wmlDocumentEl.setBody(body);
        PageDimensions page = new PageDimensions();
        page.setPgSize(sz, landscape);
        SectPr sectPr = factory.createSectPr();
        body.setSectPr(sectPr);
        sectPr.setPgSz(page.getPgSz());
        sectPr.setPgMar(page.getPgMar());
        wordDocumentPart.setJaxbElement((Object)wmlDocumentEl);
        wmlPack.addTargetPart((Part)wordDocumentPart);
        StyleDefinitionsPart stylesPart = new StyleDefinitionsPart();
        try {
            this.unmarshalDefaultStyles(stylesPart, "aurora/ide/meta/docx4j/docx/sample/styles.xml");
            wordDocumentPart.addTargetPart((Part)stylesPart);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            JaxbXmlPartXPathAware styleEffectsPart = new JaxbXmlPartXPathAware(new PartName("/word/stylesWithEffects.xml")){};
            styleEffectsPart.setContentType(new ContentType("application/vnd.ms-word.stylesWithEffects+xml"));
            styleEffectsPart.setRelationshipType("http://schemas.microsoft.com/office/2007/relationships/stylesWithEffects");
            this.unmarshalDefaultStyles(styleEffectsPart, "aurora/ide/meta/docx4j/docx/sample/stylesWithEffects.xml");
            wordDocumentPart.addTargetPart((Part)styleEffectsPart);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        DocPropsCorePart core = new DocPropsCorePart();
        org.docx4j.docProps.core.ObjectFactory coreFactory = new org.docx4j.docProps.core.ObjectFactory();
        core.setJaxbElement((Object)coreFactory.createCoreProperties());
        wmlPack.addTargetPart((Part)core);
        DocPropsExtendedPart app = new DocPropsExtendedPart();
        org.docx4j.docProps.extended.ObjectFactory extFactory = new org.docx4j.docProps.extended.ObjectFactory();
        app.setJaxbElement((Object)extFactory.createProperties());
        wmlPack.addTargetPart((Part)app);
        return wmlPack;
    }

    protected Object unmarshalDefaultStyles(StyleDefinitionsPart stylesPart, String path) throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource((String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stylesPart.unmarshal(is);
    }

    protected Object unmarshalDefaultStyles(JaxbXmlPartXPathAware stylesPart, String path) throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource((String)path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stylesPart.unmarshal(is);
    }

    protected Relationship createFooterPart(WordprocessingMLPackage wordprocessingMLPackage) throws Exception {
        FooterPart headerPart = new FooterPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        headerPart.setJaxbElement((Object)this.getFtr(wordprocessingMLPackage, (Part)headerPart));
        return rel;
    }

    private Ftr getFtr(WordprocessingMLPackage wordPackage, Part sourcePart) throws Exception {
        Jc jc;
        org.docx4j.wml.ObjectFactory factory = new org.docx4j.wml.ObjectFactory();
        Ftr ftr = factory.createFtr();
        P p = factory.createP();
        Text t = factory.createText();
        t.setValue("Company Confidential - For internal use only");
        R run = factory.createR();
        run.getContent().add(t);
        p.getContent().add(run);
        PPr pPr = p.getPPr();
        if (pPr == null) {
            pPr = factory.createPPr();
        }
        if ((jc = pPr.getJc()) == null) {
            jc = new Jc();
        }
        jc.setVal(JcEnumeration.CENTER);
        pPr.setJc(jc);
        p.setPPr(pPr);
        ftr.getContent().add(p);
        return ftr;
    }

    protected void createFooterReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = this.objectFactory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        FooterReference headerReference = this.objectFactory.createFooterReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
    }

    protected Relationship createHeaderPart(WordprocessingMLPackage wordprocessingMLPackage) throws Exception {
        HeaderPart headerPart = new HeaderPart();
        Relationship rel = wordprocessingMLPackage.getMainDocumentPart().addTargetPart((Part)headerPart);
        headerPart.setJaxbElement((Object)this.getHdr(wordprocessingMLPackage, (Part)headerPart));
        return rel;
    }

    protected void createHeaderReference(WordprocessingMLPackage wordprocessingMLPackage, Relationship relationship) throws InvalidFormatException {
        List sections = wordprocessingMLPackage.getDocumentModel().getSections();
        SectPr sectPr = ((SectionWrapper)sections.get(sections.size() - 1)).getSectPr();
        if (sectPr == null) {
            sectPr = this.objectFactory.createSectPr();
            wordprocessingMLPackage.getMainDocumentPart().addObject((Object)sectPr);
            ((SectionWrapper)sections.get(sections.size() - 1)).setSectPr(sectPr);
        }
        HeaderReference headerReference = this.objectFactory.createHeaderReference();
        headerReference.setId(relationship.getId());
        headerReference.setType(HdrFtrRef.DEFAULT);
        sectPr.getEGHdrFtrReferences().add(headerReference);
    }

    protected Hdr getHdr(WordprocessingMLPackage wordprocessingMLPackage, Part sourcePart) throws Exception {
        Hdr hdr = this.objectFactory.createHdr();
        File file = new File(String.valueOf(System.getProperty("user.dir")) + "/src/test/resources/images/hand-china.png");
        FileInputStream is = new FileInputStream(file);
        hdr.getContent().add(this.newImage(wordprocessingMLPackage, sourcePart, BufferUtil.getBytesFromInputStream((InputStream)is), "hand-china", "hand-china", 1, 2));
        return hdr;
    }

    protected P newImage(WordprocessingMLPackage wordMLPackage, Part sourcePart, byte[] bytes, String filenameHint, String altText, int id1, int id2) throws Exception {
        Jc jc;
        BinaryPartAbstractImage imagePart = BinaryPartAbstractImage.createImagePart((OpcPackage)wordMLPackage, (Part)sourcePart, (byte[])bytes);
        Inline inline = imagePart.createImageInline(filenameHint, altText, id1, id2, 2000L, false);
        new org.docx4j.dml.ObjectFactory();
        new ObjectFactory();
        org.docx4j.wml.ObjectFactory factory = Context.getWmlObjectFactory();
        P p = factory.createP();
        R run = factory.createR();
        p.getContent().add(run);
        Drawing drawing = factory.createDrawing();
        run.getContent().add(drawing);
        drawing.getAnchorOrInline().add(inline);
        PPr pPr = p.getPPr();
        if (pPr == null) {
            pPr = factory.createPPr();
        }
        if ((jc = pPr.getJc()) == null) {
            jc = new Jc();
        }
        jc.setVal(JcEnumeration.RIGHT);
        pPr.setJc(jc);
        p.setPPr(pPr);
        return p;
    }

    public WordprocessingMLPackage getWordMLPackage() {
        return this.wordMLPackage;
    }

    public MainDocumentPart getMainDocumentPart() {
        return this.wordMLPackage.getMainDocumentPart();
    }
}

