/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.command;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.plugin.source.gen.screen.model.CustomICon;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.ImageData;

public class ChangeImageCommand
extends Command {
    private ImageData loadImageData;
    private CustomICon model;
    private int oldHeight = -1;
    private int oldWidth = -1;
    private byte[] oldIconByteData;
    private int iconType;

    public ChangeImageCommand(CustomICon model, ImageData loadImageData, int iconType) {
        this.model = model;
        this.loadImageData = loadImageData;
        this.iconType = iconType;
        this.setLabel("Change Icon");
    }

    public void execute() {
        this.oldWidth = this.model.getIntegerPropertyValue("image_width");
        this.oldHeight = this.model.getIntegerPropertyValue("image_height");
        this.oldIconByteData = AuroraImagesUtils.toBytes((String)this.model.getIconByteData());
        this.model.setPropertyValue("image_width", (Object)this.loadImageData.width);
        this.model.setPropertyValue("image_height", (Object)this.loadImageData.height);
        byte[] bytes = AuroraImagesUtils.toBytes((ImageData)this.loadImageData, (int)this.iconType);
        this.model.setIconByteData(AuroraImagesUtils.toString((byte[])bytes));
    }

    public void undo() {
        this.model.setPropertyValue("image_width", (Object)this.oldWidth);
        this.model.setPropertyValue("image_height", (Object)this.oldHeight);
        this.model.setIconByteData(AuroraImagesUtils.toString((byte[])this.oldIconByteData));
    }
}

